/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.kv.Delete;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class DeleteTest {
    static final String TEST_KV_KEY = "test-key";
    @Inject
    TestRunContextFactory runContextFactory;

    DeleteTest() {
    }

    @Test
    void shouldOutputTrueGivenExistingKey() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespaceId, Map.of("inputs", Map.of("key", TEST_KV_KEY, "namespace", namespaceId)));
        Delete delete = ((Delete.DeleteBuilder)((Delete.DeleteBuilder)Delete.builder().id(Delete.class.getSimpleName())).type(Delete.class.getName())).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).key(Property.ofExpression((String)"{{ inputs.key }}")).build();
        KVStore kv = runContext.namespaceKv(namespaceId);
        kv.put(TEST_KV_KEY, new KVValueAndMetadata(null, (Object)"value"));
        Delete.Output run = delete.run(runContext);
        Assertions.assertThat((boolean)run.isDeleted()).isTrue();
    }

    @Test
    void shouldOutputFalseGivenNonExistingKey() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespaceId, Map.of("inputs", Map.of("key", TEST_KV_KEY, "namespace", namespaceId)));
        Delete delete = ((Delete.DeleteBuilder)((Delete.DeleteBuilder)Delete.builder().id(Delete.class.getSimpleName())).type(Delete.class.getName())).namespace(Property.ofValue((Object)namespaceId)).key(Property.ofValue((Object)"my-key")).build();
        Delete.Output run = delete.run(runContext);
        Assertions.assertThat((boolean)run.isDeleted()).isFalse();
        Delete finalDelete = delete.toBuilder().errorOnMissing(Property.ofValue((Object)true)).build();
        NoSuchElementException noSuchElementException = (NoSuchElementException)org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> finalDelete.run(runContext));
        Assertions.assertThat((String)noSuchElementException.getMessage()).isEqualTo("No value found for key 'my-key' in namespace '" + namespaceId + "' and `errorOnMissing` is set to true");
    }
}

