/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.kv.GetKeys;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class GetKeysTest {
    static final String TEST_KEY_PREFIX_TEST = "test";
    @Inject
    TestRunContextFactory runContextFactory;

    GetKeysTest() {
    }

    @Test
    void shouldGetAllKeys() throws Exception {
        String namespace = IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespace);
        GetKeys getKeys = ((GetKeys.GetKeysBuilder)((GetKeys.GetKeysBuilder)GetKeys.builder().id(GetKeys.class.getSimpleName())).type(GetKeys.class.getName())).build();
        KVStore kv = runContext.namespaceKv(namespace);
        kv.put("test-key", new KVValueAndMetadata(null, (Object)"value"));
        kv.put("test-second-key", new KVValueAndMetadata(null, (Object)"value"));
        kv.put("another-key", new KVValueAndMetadata(null, (Object)"value"));
        GetKeys.Output run = getKeys.run(runContext);
        Assertions.assertThat((List)run.getKeys()).containsExactlyInAnyOrder((Object[])new String[]{"test-key", "test-second-key", "another-key"});
    }

    @Test
    void shouldGetKeysGivenMatchingPrefix() throws Exception {
        String namespace = IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespace, Map.of("inputs", Map.of("prefix", TEST_KEY_PREFIX_TEST)));
        GetKeys getKeys = ((GetKeys.GetKeysBuilder)((GetKeys.GetKeysBuilder)GetKeys.builder().id(GetKeys.class.getSimpleName())).type(GetKeys.class.getName())).prefix(Property.ofExpression((String)"{{ inputs.prefix }}")).build();
        KVStore kv = runContext.namespaceKv(namespace);
        kv.put("test-key", new KVValueAndMetadata(null, (Object)"value"));
        kv.put("test-second-key", new KVValueAndMetadata(null, (Object)"value"));
        kv.put("another-key", new KVValueAndMetadata(null, (Object)"value"));
        GetKeys.Output run = getKeys.run(runContext);
        Assertions.assertThat((List)run.getKeys()).containsExactlyInAnyOrder((Object[])new String[]{"test-key", "test-second-key"});
    }

    @Test
    void shouldGetNoKeysGivenEmptyKeyStore() throws Exception {
        String namespace = IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespace, Map.of("inputs", Map.of("prefix", TEST_KEY_PREFIX_TEST)));
        GetKeys getKeys = ((GetKeys.GetKeysBuilder)((GetKeys.GetKeysBuilder)GetKeys.builder().id(GetKeys.class.getSimpleName())).type(GetKeys.class.getName())).prefix(Property.ofExpression((String)"{{ inputs.prefix }}")).build();
        GetKeys.Output run = getKeys.run(runContext);
        Assertions.assertThat((List)run.getKeys()).isEmpty();
    }
}

