/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.kv.Get;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class GetTest {
    static final String TEST_KV_KEY = "test-key";
    @Inject
    TestRunContextFactory runContextFactory;

    GetTest() {
    }

    @Test
    void shouldGetGivenExistingKey() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespaceId, Map.of("inputs", Map.of("key", TEST_KV_KEY, "namespace", namespaceId)));
        Map<String, String> value = Map.of("date", Instant.now().truncatedTo(ChronoUnit.MILLIS), "int", 1, "string", "string");
        Get get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(Get.class.getSimpleName())).type(Get.class.getName())).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).key(Property.ofExpression((String)"{{ inputs.key }}")).build();
        KVStore kv = runContext.namespaceKv(namespaceId);
        kv.put(TEST_KV_KEY, new KVValueAndMetadata(null, value));
        Get.Output run = get.run(runContext);
        Assertions.assertThat((Object)run.getValue()).isEqualTo(value);
    }

    @Test
    void shouldGetGivenExistingKeyWithInheritance() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespaceId, Map.of("inputs", Map.of("key", TEST_KV_KEY)));
        Map<String, String> value = Map.of("date", Instant.now().truncatedTo(ChronoUnit.MILLIS), "int", 1, "string", "string");
        Get get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(Get.class.getSimpleName())).type(Get.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).build();
        KVStore kv = runContext.namespaceKv("io.kestra");
        kv.put(TEST_KV_KEY, new KVValueAndMetadata(null, value));
        Get.Output run = get.run(runContext);
        Assertions.assertThat((Object)run.getValue()).isEqualTo(value);
    }

    @Test
    void shouldGetGivenNonExistingKey() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        RunContext runContext = this.runContextFactory.of(namespaceId, Map.of("inputs", Map.of("key", TEST_KV_KEY, "namespace", namespaceId)));
        Get get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(Get.class.getSimpleName())).type(Get.class.getName())).namespace(Property.ofValue((Object)namespaceId)).key(Property.ofValue((Object)"my-key")).build();
        Get.Output run = get.run(runContext);
        Assertions.assertThat((Object)run.getValue()).isNull();
        Get finalGet = get.toBuilder().errorOnMissing(Property.ofValue((Object)true)).build();
        NoSuchElementException noSuchElementException = (NoSuchElementException)org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> finalGet.run(runContext));
        Assertions.assertThat((String)noSuchElementException.getMessage()).isEqualTo("No value found for key 'my-key' in namespace '" + namespaceId + "' and `errorOnMissing` is set to true");
    }
}

