/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.ValidationErrorException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.FetchVersion;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.kv.Key;
import io.kestra.plugin.core.kv.PurgeKV;
import io.kestra.plugin.core.kv.Version;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
@KestraTest
public class PurgeKVTest {
    public static final String PARENT_NAMESPACE = "parent";
    public static final String CHILD_NAMESPACE = "parent.child";
    public static final String NAMESPACE = "io.kestra.tests";
    public static final String KEY_EXPIRED = "key_expired";
    public static final String KEY = "key";
    public static final String KEY2_NEVER_EXPIRING = "key2_never_expired";
    public static final String KEY3_NEVER_EXPIRING = "key3_never_expired";
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    FlowRepositoryInterface flowRepositoryInterface;
    @Inject
    ModelValidator modelValidator;

    @BeforeEach
    protected void setup() throws IOException {
        this.flowRepositoryInterface.findAll("main").forEach(flow -> this.flowRepositoryInterface.delete((FlowInterface)flow));
    }

    @Test
    void should_find_all_namespaces() throws IllegalVariableEvaluationException {
        this.addNamespaces();
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).build();
        List namespaces = purgeKV.findNamespaces(this.runContextFactory.of(NAMESPACE));
        Assertions.assertThat((List)namespaces).containsExactlyInAnyOrder((Object[])new String[]{NAMESPACE, CHILD_NAMESPACE, PARENT_NAMESPACE});
    }

    @Test
    void should_find_all_namespaces_with_glob_pattern() throws IllegalVariableEvaluationException {
        this.addNamespaces();
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).namespacePattern(Property.ofValue((Object)"*arent*")).build();
        List namespaces = purgeKV.findNamespaces(this.runContextFactory.of(NAMESPACE));
        Assertions.assertThat((List)namespaces).containsExactlyInAnyOrder((Object[])new String[]{CHILD_NAMESPACE, PARENT_NAMESPACE});
    }

    @Test
    void should_find_all_namespaces_with_namespace_list_without_child() throws IllegalVariableEvaluationException {
        this.addNamespaces();
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).namespaces(Property.ofValue(List.of("ns1", "ns2", PARENT_NAMESPACE))).includeChildNamespaces(Property.ofValue((Object)false)).build();
        List namespaces = purgeKV.findNamespaces(this.runContextFactory.of(NAMESPACE));
        Assertions.assertThat((List)namespaces).containsExactlyInAnyOrder((Object[])new String[]{PARENT_NAMESPACE});
    }

    @Test
    void should_find_all_namespaces_with_namespace_list_with_child() throws IllegalVariableEvaluationException {
        this.addNamespaces();
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).namespaces(Property.ofValue(List.of("ns1", "ns2", PARENT_NAMESPACE))).includeChildNamespaces(Property.ofValue((Object)true)).build();
        List namespaces = purgeKV.findNamespaces(this.runContextFactory.of(NAMESPACE));
        Assertions.assertThat((List)namespaces).containsExactlyInAnyOrder((Object[])new String[]{PARENT_NAMESPACE, CHILD_NAMESPACE});
    }

    @Test
    void should_not_find_namespaces_with_incorrect_parameters() {
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).namespaces(Property.ofValue(List.of("ns1", "ns2", PARENT_NAMESPACE))).namespacePattern(Property.ofValue((Object)"*par*")).build();
        org.junit.jupiter.api.Assertions.assertThrows(ValidationErrorException.class, () -> purgeKV.findNamespaces(this.runContextFactory.of(NAMESPACE)));
    }

    @Test
    void should_delete_every_expired_from_every_namespaces_without_parameters() throws Exception {
        String namespace1 = "io.kestra." + IdUtils.create();
        String namespace2 = "io.kestra." + IdUtils.create();
        this.addNamespace(namespace1);
        this.addNamespace(namespace2);
        RunContext runContext = this.runContextFactory.of(namespace1);
        KVStore kvStore1 = runContext.namespaceKv(namespace1);
        kvStore1.put(KEY_EXPIRED, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore1.put(KEY, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMinutes(1L)), (Object)"unused"));
        KVStore kvStore2 = runContext.namespaceKv(namespace2);
        kvStore2.put(KEY_EXPIRED, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore2.put(KEY, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMinutes(1L)), (Object)"unused"));
        kvStore2.put(KEY2_NEVER_EXPIRING, new KVValueAndMetadata(new KVMetadata("unused", (Duration)null), (Object)"unused"));
        kvStore2.put(KEY3_NEVER_EXPIRING, new KVValueAndMetadata(null, (Object)"unused"));
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).build();
        PurgeKV.Output output = purgeKV.run(runContext);
        Assertions.assertThat((Long)output.getSize()).isEqualTo(2L);
        Assertions.assertThat((Optional)kvStore1.get(KEY_EXPIRED)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY)).isPresent();
        Assertions.assertThat((Optional)kvStore2.get(KEY_EXPIRED)).isEmpty();
        Assertions.assertThat((Optional)kvStore2.get(KEY)).isPresent();
        Assertions.assertThat((Optional)kvStore2.get(KEY2_NEVER_EXPIRING)).isPresent();
        Assertions.assertThat((Optional)kvStore2.get(KEY3_NEVER_EXPIRING)).isPresent();
    }

    @Test
    void should_delete_every_expired_and_non_expired() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        this.addNamespace(namespace);
        RunContext runContext = this.runContextFactory.of(namespace);
        KVStore kvStore1 = runContext.namespaceKv(namespace);
        kvStore1.put(KEY_EXPIRED, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore1.put(KEY, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMinutes(1L)), (Object)"unused"));
        kvStore1.put(KEY2_NEVER_EXPIRING, new KVValueAndMetadata(new KVMetadata("unused", (Duration)null), (Object)"unused"));
        kvStore1.put(KEY3_NEVER_EXPIRING, new KVValueAndMetadata(null, (Object)"unused"));
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Key.builder().expiredOnly(false).build())).build();
        PurgeKV.Output output = purgeKV.run(runContext);
        Assertions.assertThat((Long)output.getSize()).isEqualTo(4L);
        Assertions.assertThat((Optional)kvStore1.get(KEY_EXPIRED)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY2_NEVER_EXPIRING)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY3_NEVER_EXPIRING)).isEmpty();
    }

    @Test
    void expiredOnly_still_supported_and_overrides_behavior() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        this.addNamespace(namespace);
        RunContext runContext = this.runContextFactory.of(namespace);
        KVStore kvStore1 = runContext.namespaceKv(namespace);
        kvStore1.put(KEY_EXPIRED, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore1.put(KEY, new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMinutes(1L)), (Object)"unused"));
        kvStore1.put(KEY2_NEVER_EXPIRING, new KVValueAndMetadata(new KVMetadata("unused", (Duration)null), (Object)"unused"));
        kvStore1.put(KEY3_NEVER_EXPIRING, new KVValueAndMetadata(null, (Object)"unused"));
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Key.builder().expiredOnly(true).build())).expiredOnly(Property.ofValue((Object)false)).build();
        PurgeKV.Output output = purgeKV.run(runContext);
        Assertions.assertThat((Long)output.getSize()).isEqualTo(4L);
        Assertions.assertThat((Optional)kvStore1.get(KEY_EXPIRED)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY2_NEVER_EXPIRING)).isEmpty();
        Assertions.assertThat((Optional)kvStore1.get(KEY3_NEVER_EXPIRING)).isEmpty();
    }

    @Test
    void should_delete_every_keys_matching_pattern() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        this.addNamespace(namespace);
        RunContext runContext = this.runContextFactory.of(namespace);
        KVStore kvStore1 = runContext.namespaceKv(namespace);
        kvStore1.put("key_1", new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore1.put("key_2", new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        kvStore1.put("not_found", new KVValueAndMetadata(new KVMetadata("unused", Duration.ofMillis(1L)), (Object)"unused"));
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).keyPattern(Property.ofValue((Object)"*ey*")).build();
        PurgeKV.Output output = purgeKV.run(runContext);
        Assertions.assertThat((Long)output.getSize()).isEqualTo(2L);
        List kvEntries = kvStore1.listAll();
        Assertions.assertThat((int)kvEntries.size()).isEqualTo(1);
        Assertions.assertThat((String)((KVEntry)kvEntries.getFirst()).key()).isEqualTo("not_found");
    }

    @Test
    void version_filter_by_date() throws Exception {
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        this.addNamespace(namespace);
        RunContext runContext = this.runContextFactory.of(namespace);
        KVStore kvStore = runContext.namespaceKv(namespace);
        kvStore.put("my-key", new KVValueAndMetadata(new KVMetadata("Some description", Instant.now().plus(Duration.ofMinutes(5L))), (Object)"some value"));
        Instant afterFirstVersion = Instant.now();
        String changedDescription = "Another description";
        kvStore.put("my-key", new KVValueAndMetadata(new KVMetadata(changedDescription, Instant.now().plus(Duration.ofMinutes(5L))), (Object)"some value"));
        ArrayListTotal kvs = kvStore.list(Pageable.UNPAGED, Collections.emptyList(), true, true, FetchVersion.ALL);
        Assertions.assertThat((int)kvs.size()).isEqualTo(2);
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Version.builder().before(afterFirstVersion.toString()).build())).build();
        PurgeKV.Output run = purgeKV.run(runContext);
        Assertions.assertThat((Long)run.getSize()).isEqualTo(1L);
        kvs = kvStore.list(Pageable.UNPAGED, Collections.emptyList(), true, true, FetchVersion.ALL);
        Assertions.assertThat((int)kvs.size()).isEqualTo(1);
        Assertions.assertThat((String)((KVEntry)kvs.getFirst()).description()).isEqualTo(changedDescription);
    }

    @Test
    void version_filter_by_keep_amount() throws Exception {
        String namespace = TestsUtils.randomNamespace((String[])new String[0]);
        this.addNamespace(namespace);
        RunContext runContext = this.runContextFactory.of(namespace);
        KVStore kvStore = runContext.namespaceKv(namespace);
        kvStore.put("my-key", new KVValueAndMetadata(new KVMetadata("Some description", Instant.now().plus(Duration.ofMinutes(5L))), (Object)"some value"));
        String secondDescription = "Another description";
        kvStore.put("my-key", new KVValueAndMetadata(new KVMetadata(secondDescription, Instant.now().plus(Duration.ofMinutes(5L))), (Object)"some value"));
        String thirdDescription = "Yet another description";
        kvStore.put("my-key", new KVValueAndMetadata(new KVMetadata(thirdDescription, Instant.now().plus(Duration.ofMinutes(5L))), (Object)"some value"));
        ArrayListTotal kvs = kvStore.list(Pageable.UNPAGED, Collections.emptyList(), true, true, FetchVersion.ALL);
        Assertions.assertThat((int)kvs.size()).isEqualTo(3);
        PurgeKV purgeKV = ((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Version.builder().keepAmount(Integer.valueOf(2)).build())).build();
        PurgeKV.Output run = purgeKV.run(runContext);
        Assertions.assertThat((Long)run.getSize()).isEqualTo(1L);
        kvs = kvStore.list(Pageable.UNPAGED, Collections.emptyList(), true, true, FetchVersion.ALL);
        Assertions.assertThat((int)kvs.size()).isEqualTo(2);
        Assertions.assertThat(kvs.stream().map(KVEntry::description)).containsExactlyInAnyOrder((Object[])new String[]{secondDescription, thirdDescription});
    }

    @Test
    void validation() throws Exception {
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)((PurgeKV.PurgeKVBuilder)((PurgeKV.PurgeKVBuilder)PurgeKV.builder().id(IdUtils.create())).type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Version.builder().before(Instant.now().toString()).build())).build()).isPresent()).isFalse();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)((PurgeKV.PurgeKVBuilder)((PurgeKV.PurgeKVBuilder)PurgeKV.builder().id(IdUtils.create())).type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Version.builder().keepAmount(Integer.valueOf(2)).build())).build()).isPresent()).isFalse();
        Optional invalid = this.modelValidator.isValid((Object)((PurgeKV.PurgeKVBuilder)((PurgeKV.PurgeKVBuilder)PurgeKV.builder().id(IdUtils.create())).type(PurgeKV.class.getName())).behavior(Property.ofValue((Object)Version.builder().before(Instant.now().toString()).keepAmount(Integer.valueOf(2)).build())).build());
        Assertions.assertThat((boolean)invalid.isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)((Object)invalid.get())).getMessage()).contains(new CharSequence[]{"behavior: Cannot set both 'before' and 'keepAmount' properties"});
    }

    private void addNamespaces() {
        this.addNamespace(NAMESPACE);
        this.addNamespace(PARENT_NAMESPACE);
        this.addNamespace(CHILD_NAMESPACE);
    }

    private void addNamespace(String namespace) {
        this.flowRepositoryInterface.create(GenericFlow.of((FlowInterface)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().tenantId("main")).namespace(namespace)).id("flow1")).tasks(List.of(((PurgeKV.PurgeKVBuilder)PurgeKV.builder().type(PurgeKV.class.getName())).build())).build()));
    }
}

