/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.kv;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.FlakyTest;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.kv.KVType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.storages.kv.KVStoreException;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.kv.Set;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

@KestraTest
class SetTest {
    @Inject
    TestRunContextFactory runContextFactory;

    SetTest() {
    }

    @Test
    void shouldSetKVGivenNoNamespace() throws Exception {
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).kvDescription(Property.ofExpression((String)"{{ inputs.description }}")).build();
        Map<String, String> value = Map.of("date", Instant.now().truncatedTo(ChronoUnit.MILLIS), "int", 1, "string", "string");
        String description = "myDescription";
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)set, Map.of("key", "no_ns_key", "value", value, "description", description));
        set.run(runContext);
        KVStore kv = runContext.namespaceKv(runContext.flowInfo().namespace());
        Optional kvValueOptional = kv.getValue("no_ns_key");
        ((OptionalAssert)Assertions.assertThat((Optional)kvValueOptional).isPresent()).get().isEqualTo((Object)new KVValue(value));
        Optional noNsKey = kv.get("no_ns_key");
        Assertions.assertThat((Optional)noNsKey).isPresent();
        KVEntry kvEntry = (KVEntry)noNsKey.get();
        Assertions.assertThat((Instant)kvEntry.expirationDate()).isNull();
        Assertions.assertThat((String)kvEntry.description()).isEqualTo(description);
    }

    @Test
    void shouldSetKVGivenSameNamespace() throws Exception {
        RunContext runContext = this.runContextFactory.of("io.kestra.test", Map.of("inputs", Map.of("key", "same_ns_key", "value", "test-value")));
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).namespace(Property.ofValue((Object)"io.kestra.test")).build();
        set.run(runContext);
        KVStore kv = runContext.namespaceKv("io.kestra.test");
        Assertions.assertThat((Optional)kv.getValue("same_ns_key")).isEqualTo(Optional.of(new KVValue((Object)"test-value")));
        Assertions.assertThat((Instant)((KVEntry)kv.list().getFirst()).expirationDate()).isNull();
    }

    @Test
    void shouldSetKVGivenChildNamespace() throws Exception {
        RunContext runContext = this.runContextFactory.of("io.kestra.test", Map.of("inputs", Map.of("key", "child_ns_key", "value", "test-value")));
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).namespace(Property.ofValue((Object)"io.kestra")).build();
        set.run(runContext);
        KVStore kv = runContext.namespaceKv("io.kestra");
        Assertions.assertThat((Optional)kv.getValue("child_ns_key")).isEqualTo(Optional.of(new KVValue((Object)"test-value")));
        Assertions.assertThat((Instant)((KVEntry)kv.list().getFirst()).expirationDate()).isNull();
    }

    @Test
    void shouldFailGivenNonExistingNamespace() {
        RunContext runContext = this.runContextFactory.of("io.kestra.test", Map.of("inputs", Map.of("key", "non_existing_ns_key", "value", "test-value")));
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).namespace(Property.ofValue((Object)"not-found")).build();
        org.junit.jupiter.api.Assertions.assertThrows(KVStoreException.class, () -> set.run(runContext));
    }

    @Test
    void shouldSetKVGivenTTL() throws Exception {
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).ttl(Property.ofValue((Object)Duration.ofMinutes(5L))).build();
        Map<String, String> value = Map.of("date", Instant.now().truncatedTo(ChronoUnit.MILLIS), "int", 1, "string", "string");
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)set, Map.of("key", "ttl_key", "value", value));
        set.run(runContext);
        KVStore kv = runContext.namespaceKv(runContext.flowInfo().namespace());
        Assertions.assertThat((Optional)kv.getValue("ttl_key")).isEqualTo(Optional.of(new KVValue(value)));
        Instant expirationDate = ((KVEntry)kv.get("ttl_key").get()).expirationDate();
        Assertions.assertThat((expirationDate.isAfter(Instant.now().plus(Duration.ofMinutes(4L))) && expirationDate.isBefore(Instant.now().plus(Duration.ofMinutes(6L))) ? 1 : 0) != 0).isTrue();
    }

    @FlakyTest
    @Test
    void shouldFailGivenExistingKeyAndOverwriteFalse() throws Exception {
        String key = IdUtils.create();
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).overwrite(Property.ofValue((Object)false)).build();
        Map<String, String> value = Map.of("date", Instant.now().truncatedTo(ChronoUnit.MILLIS), "int", 1, "string", "string");
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)set, Map.of("key", key, "value", value));
        runContext.namespaceKv(runContext.flowInfo().namespace()).put(key, new KVValueAndMetadata(new KVMetadata("unused", (Instant)null), value));
        KVStoreException exception = (KVStoreException)org.junit.jupiter.api.Assertions.assertThrows(KVStoreException.class, () -> ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofExpression((String)"{{ inputs.key }}")).value(Property.ofExpression((String)"{{ inputs.value }}")).overwrite(Property.ofValue((Object)false)).build().run(runContext));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("Cannot set value for key '%s'. Key already exists and `overwrite` is set to `false`.".formatted(key));
    }

    @Test
    void typeSpecified() throws Exception {
        String key = "specified_key";
        KVStore kv = this.createAndPerformSetTask(key, "123.45", KVType.NUMBER);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo((Object)123.45);
        kv = this.createAndPerformSetTask(key, "true", KVType.BOOLEAN);
        Assertions.assertThat((Boolean)((Boolean)((KVValue)kv.getValue(key).orElseThrow()).value())).isTrue();
        kv = this.createAndPerformSetTask(key, "2023-05-02T01:02:03Z", KVType.DATETIME);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo((Object)Instant.parse("2023-05-02T01:02:03Z"));
        kv = this.createAndPerformSetTask(key, "P1DT5S", KVType.DURATION);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo((Object)Duration.ofDays(1L).plus(Duration.ofSeconds(5L)));
        kv = this.createAndPerformSetTask(key, "[{\"some\":\"value\"},{\"another\":\"value\"}]", KVType.JSON);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo(List.of(Map.of("some", "value"), Map.of("another", "value")));
        kv = this.createAndPerformSetTask(key, "{{ 200 }}", KVType.STRING);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo((Object)"200");
        kv = this.createAndPerformSetTask(key, "{{ 200.1 }}", KVType.STRING);
        Assertions.assertThat((Object)((KVValue)kv.getValue(key).orElseThrow()).value()).isEqualTo((Object)"200.1");
    }

    private KVStore createAndPerformSetTask(String key, String value, KVType type) throws Exception {
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(Set.class.getSimpleName())).type(Set.class.getName())).key(Property.ofValue((Object)key)).value(value.contains("{{") ? Property.ofExpression((String)value) : Property.ofValue((Object)value)).kvType(Property.ofValue((Object)type)).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)set, null);
        set.run(runContext);
        return runContext.namespaceKv(runContext.flowInfo().namespace());
    }
}

