/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.log;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.event.Level;

@KestraTest(startRunner=true)
class PurgeLogsTest {
    @Inject
    private LogRepositoryInterface logRepository;
    @Inject
    protected TestRunnerUtils runnerUtils;

    PurgeLogsTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/purge_logs_no_arguments.yaml"})
    void run_with_no_arguments() throws Exception {
        LogEntry logEntry = LogEntry.builder().namespace("namespace").flowId("flowId").tenantId("main").timestamp(Instant.now()).level(Level.INFO).message("Hello World").build();
        this.logRepository.save(logEntry);
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "purge_logs_no_arguments");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)execution.getState().isSuccess());
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((int)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"count"))).isPositive();
    }

    @org.junit.jupiter.api.parallel.Execution(value=ExecutionMode.SAME_THREAD)
    @ParameterizedTest
    @MethodSource(value={"buildArguments"})
    @LoadFlows(value={"flows/valids/purge_logs_full_arguments.yaml"})
    void run_with_full_arguments(LogEntry logEntry, int resultCount, String failingReason) throws Exception {
        this.logRepository.save(logEntry);
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "purge_logs_full_arguments");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)execution.getState().isSuccess());
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        ((ObjectAssert)Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"count")).as(failingReason, new Object[0])).isEqualTo((Object)resultCount);
    }

    static Stream<Arguments> buildArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("purge.namespace").flowId("purgeFlowId").tenantId("main").timestamp(Instant.now().plus(5L, ChronoUnit.HOURS)).level(Level.INFO).message("Hello World").build(), 0, "The log is too recent to be found"}), Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("purge.namespace").flowId("purgeFlowId").tenantId("main").timestamp(Instant.now().minus(5L, ChronoUnit.HOURS)).level(Level.INFO).message("Hello World").build(), 0, "The log is too old to be found"}), Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("uncorrect.namespace").flowId("purgeFlowId").tenantId("main").timestamp(Instant.now().minusSeconds(10L)).level(Level.INFO).message("Hello World").build(), 0, "The log has an incorrect namespace"}), Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("purge.namespace").flowId("wrongFlowId").tenantId("main").timestamp(Instant.now().minusSeconds(10L)).level(Level.INFO).message("Hello World").build(), 0, "The log has an incorrect flow id"}), Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("purge.namespace").flowId("purgeFlowId").tenantId("main").timestamp(Instant.now().minusSeconds(10L)).level(Level.WARN).message("Hello World").build(), 0, "The log has an incorrect LogLevel"}), Arguments.of((Object[])new Object[]{LogEntry.builder().namespace("purge.namespace").flowId("purgeFlowId").tenantId("main").timestamp(Instant.now().minusSeconds(10L)).level(Level.INFO).message("Hello World").build(), 1, "The log should be deleted"}));
    }
}

