/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.Namespace;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.namespace.DeleteFiles;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class DeleteFilesTest {
    @Inject
    RunContextFactory runContextFactory;

    DeleteFilesTest() {
    }

    @Test
    void shouldDeleteNamespaceFilesForMatchingExpression() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        DeleteFiles deleteFiles = ((DeleteFiles.DeleteFilesBuilder)((DeleteFiles.DeleteFilesBuilder)DeleteFiles.builder().id(DeleteFiles.class.getSimpleName())).type(DeleteFiles.class.getName())).files(List.of("**test1*")).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)deleteFiles, Map.of("namespace", namespaceId));
        Namespace namespace = runContext.storage().namespace(namespaceId);
        namespace.putFile(Path.of("/a/b/test1.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        namespace.putFile(Path.of("/a/b/test2.txt", new String[0]), (InputStream)new ByteArrayInputStream("2".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThat((int)namespace.all("/a/b/", false).size()).isEqualTo(2);
        Assertions.assertThat((Object)deleteFiles.run(runContext)).isNotNull();
        Assertions.assertThat((int)namespace.all("/a/b/", false).size()).isEqualTo(1);
    }

    @Test
    void shouldDeleteParentFolder() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        DeleteFiles deleteFiles = ((DeleteFiles.DeleteFilesBuilder)((DeleteFiles.DeleteFilesBuilder)DeleteFiles.builder().id(DeleteFiles.class.getSimpleName())).type(DeleteFiles.class.getName())).files(List.of("**/file.txt")).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).deleteParentFolder(Property.ofValue((Object)true)).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)deleteFiles, Map.of("namespace", namespaceId));
        Namespace namespace = runContext.storage().namespace(namespaceId);
        namespace.putFile(Path.of("/folder/file.txt", new String[0]), (InputStream)new ByteArrayInputStream("content".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isEqualTo(1);
        Assertions.assertThat((Object)deleteFiles.run(runContext)).isNotNull();
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isZero();
        Assertions.assertThat((int)namespace.all("/", false).size()).isZero();
    }

    @Test
    void shouldNotDeleteParentFolderWhenFlagIsFalse() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        DeleteFiles deleteFiles = ((DeleteFiles.DeleteFilesBuilder)((DeleteFiles.DeleteFilesBuilder)DeleteFiles.builder().id(DeleteFiles.class.getSimpleName())).type(DeleteFiles.class.getName())).files(List.of("**/file.txt")).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).deleteParentFolder(Property.ofValue((Object)false)).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)deleteFiles, Map.of("namespace", namespaceId));
        Namespace namespace = runContext.storage().namespace(namespaceId);
        namespace.putFile(Path.of("/folder/file.txt", new String[0]), (InputStream)new ByteArrayInputStream("content".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isEqualTo(1);
        Assertions.assertThat((Object)deleteFiles.run(runContext)).isNotNull();
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isZero();
        Assertions.assertThat((int)namespace.all("/", true).size()).isEqualTo(1);
    }

    @Test
    void shouldNotDeleteParentFolderWhenMultipleFilesExist() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        DeleteFiles deleteFiles = ((DeleteFiles.DeleteFilesBuilder)((DeleteFiles.DeleteFilesBuilder)DeleteFiles.builder().id(DeleteFiles.class.getSimpleName())).type(DeleteFiles.class.getName())).files(List.of("**/file1.txt")).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).deleteParentFolder(Property.ofValue((Object)true)).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)deleteFiles, Map.of("namespace", namespaceId));
        Namespace namespace = runContext.storage().namespace(namespaceId);
        namespace.putFile(Path.of("/folder/file1.txt", new String[0]), (InputStream)new ByteArrayInputStream("content1".getBytes(StandardCharsets.UTF_8)));
        namespace.putFile(Path.of("/folder/file2.txt", new String[0]), (InputStream)new ByteArrayInputStream("content2".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isEqualTo(2);
        Assertions.assertThat((Object)deleteFiles.run(runContext)).isNotNull();
        Assertions.assertThat((int)namespace.all("/folder/", false).size()).isEqualTo(1);
        Assertions.assertThat((int)namespace.all("/", false).size()).isEqualTo(1);
    }
}

