/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.namespace.DownloadFiles;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class DownloadFilesTest {
    @Inject
    StorageInterface storageInterface;
    @Inject
    RunContextFactory runContextFactory;

    @Test
    void shouldDownloadNamespaceFile() throws Exception {
        String namespaceId = "io.kestra." + IdUtils.create();
        DownloadFiles downloadFiles = ((DownloadFiles.DownloadFilesBuilder)((DownloadFiles.DownloadFilesBuilder)DownloadFiles.builder().id(DownloadFiles.class.getSimpleName())).type(DownloadFiles.class.getName())).files(List.of("**test1.txt")).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)downloadFiles, Map.of("namespace", namespaceId));
        Namespace namespace = runContext.storage().namespace(namespaceId);
        namespace.putFile(Path.of("/a/b/test1.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        namespace.putFile(Path.of("/a/b/test2.txt", new String[0]), (InputStream)new ByteArrayInputStream("2".getBytes(StandardCharsets.UTF_8)));
        DownloadFiles.Output output = downloadFiles.run(runContext);
        Assertions.assertThat((int)output.getFiles().size()).isEqualTo(1);
        Assertions.assertThat((URI)((URI)output.getFiles().get("/a/b/test1.txt"))).isNotNull();
    }
}

