/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import com.devskiller.friendly_id.FriendlyId;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.namespace.UploadFiles;
import io.micrometer.core.instrument.util.IOUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class UploadFilesTest {
    @Inject
    StorageInterface storageInterface;
    @Inject
    RunContextFactory runContextFactory;

    @Test
    void shouldThrowExceptionGivenAlreadyExistingFileWhenConflictError() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        File file = new File(Objects.requireNonNull(UploadFilesTest.class.getClassLoader().getResource("application-test.yml")).toURI());
        URI fileStorage = this.storageInterface.put("main", null, new URI("/" + FriendlyId.createFriendlyId()), (InputStream)new FileInputStream(file));
        UploadFiles uploadFile = ((UploadFiles.UploadFilesBuilder)((UploadFiles.UploadFilesBuilder)UploadFiles.builder().id(UploadFiles.class.getSimpleName())).type(UploadFiles.class.getName())).filesMap(Map.of("/path/file.txt", fileStorage.toString())).namespace(Property.ofValue((Object)namespace)).conflict(Property.ofValue((Object)Namespace.Conflicts.ERROR)).destination(Property.ofValue((Object)"/folder")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)uploadFile, (Map)ImmutableMap.of());
        uploadFile.run(runContext);
        Assertions.assertThat((int)runContext.storage().namespace(namespace).all().size()).isEqualTo(1);
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> uploadFile.run(runContext));
    }

    @Test
    void shouldPutFileGivenAlreadyExistingFileWhenConflictOverwrite() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        URI fileStorage = this.addToStorage("application-test.yml");
        UploadFiles uploadFile = ((UploadFiles.UploadFilesBuilder)((UploadFiles.UploadFilesBuilder)UploadFiles.builder().id(UploadFiles.class.getSimpleName())).type(UploadFiles.class.getName())).filesMap(Map.of("/path/file.txt", fileStorage.toString())).namespace(Property.ofExpression((String)"{{ inputs.namespace }}")).destination(Property.ofValue((Object)"/folder")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)uploadFile, (Map)ImmutableMap.of((Object)"namespace", (Object)namespace));
        uploadFile.run(runContext);
        Namespace namespaceStorage = runContext.storage().namespace(namespace);
        List namespaceFiles = namespaceStorage.all();
        Assertions.assertThat((int)namespaceFiles.size()).isEqualTo(1);
        String previousFile = IOUtils.toString((InputStream)namespaceStorage.getFileContent(Path.of(((NamespaceFile)namespaceFiles.getFirst()).path(), new String[0])), (Charset)StandardCharsets.UTF_8);
        fileStorage = this.addToStorage("logback.xml");
        uploadFile = uploadFile.toBuilder().filesMap(Map.of("/path/file.txt", fileStorage.toString())).build();
        uploadFile.run(runContext);
        namespaceFiles = namespaceStorage.all();
        Assertions.assertThat((int)namespaceFiles.size()).isEqualTo(1);
        String newFile = IOUtils.toString((InputStream)namespaceStorage.getFileContent(Path.of(((NamespaceFile)namespaceFiles.getFirst()).path(), new String[0])), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((boolean)previousFile.equals(newFile)).isFalse();
    }

    @Test
    void shouldPutFileGivenAlreadyExistingFileWhenConflictSkip() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        URI fileStorage = this.addToStorage("application-test.yml");
        UploadFiles uploadFile = ((UploadFiles.UploadFilesBuilder)((UploadFiles.UploadFilesBuilder)UploadFiles.builder().id(UploadFiles.class.getSimpleName())).type(UploadFiles.class.getName())).filesMap(Map.of("/path/file.txt", fileStorage.toString())).namespace(Property.ofValue((Object)namespace)).conflict(Property.ofValue((Object)Namespace.Conflicts.SKIP)).destination(Property.ofValue((Object)"/folder")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)uploadFile, (Map)ImmutableMap.of());
        uploadFile.run(runContext);
        Namespace namespaceStorage = runContext.storage().namespace(namespace);
        List namespaceFiles = namespaceStorage.all();
        Assertions.assertThat((int)namespaceFiles.size()).isEqualTo(1);
        String previousFile = IOUtils.toString((InputStream)namespaceStorage.getFileContent(Path.of(((NamespaceFile)namespaceFiles.getFirst()).path(), new String[0])), (Charset)StandardCharsets.UTF_8);
        fileStorage = this.addToStorage("logback.xml");
        uploadFile = uploadFile.toBuilder().filesMap(Map.of("/path/file.txt", fileStorage.toString())).build();
        uploadFile.run(runContext);
        namespaceFiles = namespaceStorage.all();
        Assertions.assertThat((int)namespaceFiles.size()).isEqualTo(1);
        String newFile = IOUtils.toString((InputStream)namespaceStorage.getFileContent(Path.of(((NamespaceFile)namespaceFiles.getFirst()).path(), new String[0])), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((boolean)previousFile.equals(newFile)).isTrue();
    }

    @Test
    void shouldPutFileFromRegex() throws Exception {
        String namespace = "io.kestra." + IdUtils.create();
        UploadFiles uploadFile = ((UploadFiles.UploadFilesBuilder)((UploadFiles.UploadFilesBuilder)UploadFiles.builder().id(UploadFiles.class.getSimpleName())).type(UploadFiles.class.getName())).files(Property.ofValue(List.of("glob:**application**"))).namespace(Property.ofValue((Object)namespace)).conflict(Property.ofValue((Object)Namespace.Conflicts.SKIP)).destination(Property.ofValue((Object)"/folder/")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)uploadFile, (Map)ImmutableMap.of());
        runContext.workingDir().createFile("application-test.yml");
        uploadFile.run(runContext);
        Namespace namespaceStorage = runContext.storage().namespace(namespace);
        List namespaceFiles = namespaceStorage.all();
        Assertions.assertThat((int)namespaceFiles.size()).isEqualTo(1);
    }

    private URI addToStorage(String fileToLoad) throws IOException, URISyntaxException {
        File file = new File(Objects.requireNonNull(UploadFilesTest.class.getClassLoader().getResource(fileToLoad)).toURI());
        return this.storageInterface.put("main", null, new URI("/" + FriendlyId.createFriendlyId()), (InputStream)new FileInputStream(file));
    }
}

