/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.state;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.state.Delete;
import io.kestra.plugin.core.state.Get;
import io.kestra.plugin.core.state.Set;
import jakarta.inject.Inject;
import java.io.FileNotFoundException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class StateTest {
    @Inject
    RunContextFactory runContextFactory;

    StateTest() {
    }

    @Test
    void run() throws Exception {
        Get get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(IdUtils.create())).type(Get.class.getName())).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)get, Map.of("key", "test", "inc", 1));
        Get.Output getOutput = get.run(runContext);
        Assertions.assertThat((int)getOutput.getCount()).isZero();
        Set set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(IdUtils.create())).type(Set.class.toString())).data(Property.ofValue(Map.of("{{ inputs.key }}", "{{ inputs.inc }}"))).build();
        Set.Output setOutput = set.run(runContext);
        Assertions.assertThat((int)setOutput.getCount()).isEqualTo(1);
        get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(IdUtils.create())).type(Get.class.toString())).build();
        getOutput = get.run(runContext);
        Assertions.assertThat((int)getOutput.getCount()).isEqualTo(1);
        Assertions.assertThat(getOutput.getData().get("test")).isEqualTo((Object)"1");
        set = ((Set.SetBuilder)((Set.SetBuilder)Set.builder().id(IdUtils.create())).type(Set.class.toString())).data(Property.ofValue(Map.of("{{ inputs.key }}", "2", "test2", "3"))).build();
        setOutput = set.run(runContext);
        Assertions.assertThat((int)setOutput.getCount()).isEqualTo(2);
        get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(IdUtils.create())).type(Get.class.toString())).build();
        getOutput = get.run(runContext);
        Assertions.assertThat((int)getOutput.getCount()).isEqualTo(2);
        Assertions.assertThat(getOutput.getData().get("test")).isEqualTo((Object)"2");
        Assertions.assertThat(getOutput.getData().get("test2")).isEqualTo((Object)"3");
        Delete delete = ((Delete.DeleteBuilder)((Delete.DeleteBuilder)Delete.builder().id(IdUtils.create())).type(Get.class.toString())).build();
        Delete.Output deleteRun = delete.run(runContext);
        Assertions.assertThat((Boolean)deleteRun.getDeleted()).isTrue();
        get = ((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(IdUtils.create())).type(Get.class.toString())).build();
        getOutput = get.run(runContext);
        Assertions.assertThat((int)getOutput.getCount()).isZero();
    }

    @Test
    void deleteThrow() {
        Delete task = ((Delete.DeleteBuilder)((Delete.DeleteBuilder)((Delete.DeleteBuilder)Delete.builder().id(IdUtils.create())).type(Get.class.getName())).name(Property.ofValue((Object)IdUtils.create()))).errorOnMissing(Property.ofValue((Object)true)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> task.run(TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of())));
    }

    @Test
    void getThrow() {
        Get task = ((Get.GetBuilder)((Get.GetBuilder)((Get.GetBuilder)Get.builder().id(IdUtils.create())).type(Get.class.getName())).name(Property.ofValue((Object)IdUtils.create()))).errorOnMissing(Property.ofValue((Object)true)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> task.run(TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of())));
    }
}

