/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.google.common.io.CharStreams;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.storage.Concat;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ConcatTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    ConcatTest() {
    }

    void run(Boolean json) throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URL resource = ConcatTest.class.getClassLoader().getResource("application-test.yml");
        File file = new File(Objects.requireNonNull(ConcatTest.class.getClassLoader().getResource("application-test.yml")).toURI());
        URI put = this.storageInterface.put("main", null, new URI("/file/storage/get-%s.yml".formatted(IdUtils.create())), (InputStream)new FileInputStream(Objects.requireNonNull(resource).getFile()));
        List<String> files = Arrays.asList(put.toString(), put.toString());
        Concat result = Concat.builder().files(json != false ? JacksonMapper.ofJson().writeValueAsString(files) : files).separator(Property.ofValue((Object)"\n")).extension(Property.ofValue((Object)".yml")).build();
        Concat.Output run = result.run(runContext);
        String s = CharStreams.toString((Readable)new InputStreamReader(new FileInputStream(file)));
        Assertions.assertThat((String)CharStreams.toString((Readable)new InputStreamReader(this.storageInterface.get("main", null, run.getUri())))).isEqualTo(s + "\n" + s + "\n");
        Assertions.assertThat((String)run.getUri().getPath()).endsWith((CharSequence)".yml");
    }

    @Test
    void list() throws Exception {
        this.run(false);
    }

    @Test
    void json() throws Exception {
        this.run(true);
    }
}

