/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.DeduplicateItems;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class DeduplicateItemsTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    DeduplicateItemsTest() {
    }

    @Test
    void shouldDeduplicateFileGivenKeyExpression() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        List<KeyValue1> values = List.of(new KeyValue1("k1", "v1"), new KeyValue1("k2", "v1"), new KeyValue1("k3", "v1"), new KeyValue1("k1", "v2"), new KeyValue1("k2", "v2"), new KeyValue1("k2", null), new KeyValue1("k3", "v2"), new KeyValue1("k1", "v3"));
        DeduplicateItems task = DeduplicateItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(values, runContext).toString())).expr(" {{ key }} ").build();
        DeduplicateItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)3L, (Long)output.getNumKeys());
        Assertions.assertEquals((long)5L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)8L, (Long)output.getProcessedItemsTotal());
        List<KeyValue1> expected = List.of(new KeyValue1("k2", null), new KeyValue1("k3", "v2"), new KeyValue1("k1", "v3"));
        DeduplicateItemsTest.assertSimpleCompactedFile(runContext, output, expected, KeyValue1.class);
    }

    @Test
    void shouldDeduplicateFileGivenKeyExpressionReturningArray() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        List<KeyValue2> values = List.of(new KeyValue2("k1", "k1", "v1"), new KeyValue2("k2", "k2", "v1"), new KeyValue2("k3", "k3", "v1"), new KeyValue2("k1", "k1", "v2"), new KeyValue2("k2", "k2", null), new KeyValue2("k3", "k3", "v2"), new KeyValue2("k1", "k1", "v3"));
        DeduplicateItems task = DeduplicateItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(values, runContext).toString())).expr(" {{ key }}-{{ v1 }}").build();
        DeduplicateItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)3L, (Long)output.getNumKeys());
        Assertions.assertEquals((long)4L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)7L, (Long)output.getProcessedItemsTotal());
        List<KeyValue2> expected = List.of(new KeyValue2("k2", "k2", null), new KeyValue2("k3", "k3", "v2"), new KeyValue2("k1", "k1", "v3"));
        DeduplicateItemsTest.assertSimpleCompactedFile(runContext, output, expected, KeyValue2.class);
    }

    private static <T> void assertSimpleCompactedFile(RunContext runContext, DeduplicateItems.Output output, List<T> expected, Class<T> type) throws IOException {
        try (InputStream resource = runContext.storage().getFile(output.getUri());
             InputStreamReader inputStreamReader = new InputStreamReader(resource, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            List<Object> list = bufferedReader.lines().map(line -> {
                try {
                    return JacksonMapper.ofIon().readValue(line, type);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
            Assertions.assertEquals(expected, list);
        }
    }

    private URI generateKeyValueFile(List<?> items, RunContext runContext) throws IOException {
        Path path = runContext.workingDir().createTempFile(".ion");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            items.forEach(object -> {
                try {
                    writer.write(JacksonMapper.ofIon().writeValueAsString(object));
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return runContext.storage().putFile(path.toFile());
    }

    record KeyValue1(String key, Object value) {
    }

    record KeyValue2(String key, Object v1, Object v2) {
    }
}

