/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.Delete;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class DeleteTest {
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    DeleteTest() {
    }

    @Test
    void run() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URL resource = DeleteTest.class.getClassLoader().getResource("application-test.yml");
        URI put = this.storageInterface.put("main", null, new URI("/file/storage/get.yml"), (InputStream)new FileInputStream(Objects.requireNonNull(resource).getFile()));
        Delete bash = Delete.builder().uri(Property.ofValue((Object)put.toString())).build();
        Delete.Output run = bash.run(runContext);
        Assertions.assertThat((Boolean)run.getDeleted()).isTrue();
        run = bash.run(runContext);
        Assertions.assertThat((Boolean)run.getDeleted()).isFalse();
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchElementException.class, () -> {
            Delete error = Delete.builder().uri(Property.ofValue((Object)put.toString())).errorOnMissing(Property.ofValue((Object)true)).build();
            error.run(runContext);
        });
    }
}

