/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.FilterItems;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FilterItemsTest {
    private static final List<KeyValue> TEST_VALID_ITEMS = List.of(new KeyValue("k1", 1), new KeyValue("k2", 2), new KeyValue("k3", 3), new KeyValue("k4", 4));
    private static final List<KeyValue> TEST_INVALID_ITEMS = List.of(new KeyValue("k1", 1), new KeyValue("k2", "dummy"), new KeyValue("k3", 3), new KeyValue("k4", 4));
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    FilterItemsTest() {
    }

    @Test
    void shouldFilterGivenValidBooleanExpressionForInclude() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_VALID_ITEMS, runContext).toString())).filterCondition(" {{ value % 2 == 0 }} ").filterType(Property.ofValue((Object)FilterItems.FilterType.INCLUDE)).build();
        FilterItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)2L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)4L, (Long)output.getProcessedItemsTotal());
        FilterItemsTest.assertFile(runContext, output, List.of(new KeyValue("k2", 2), new KeyValue("k4", 4)), KeyValue.class);
    }

    @Test
    void shouldFilterGivenValidBooleanExpressionForExclude() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_VALID_ITEMS, runContext).toString())).filterCondition(" {{ value % 2 == 0 }} ").filterType(Property.ofValue((Object)FilterItems.FilterType.EXCLUDE)).build();
        FilterItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)2L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)4L, (Long)output.getProcessedItemsTotal());
        FilterItemsTest.assertFile(runContext, output, List.of(new KeyValue("k1", 1), new KeyValue("k3", 3)), KeyValue.class);
    }

    @Test
    void shouldThrowExceptionGivenInvalidRecordsForFail() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_INVALID_ITEMS, runContext).toString())).filterCondition(" {{ value % 2 == 0 }}").filterType(Property.ofValue((Object)FilterItems.FilterType.INCLUDE)).errorOrNullBehavior(Property.ofValue((Object)FilterItems.ErrorOrNullBehavior.FAIL)).build();
        Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> task.run(runContext));
    }

    @Test
    void shouldFilterGivenInvalidRecordsForInclude() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_INVALID_ITEMS, runContext).toString())).filterCondition(" {{ value % 2 == 0 }}").filterType(Property.ofValue((Object)FilterItems.FilterType.INCLUDE)).errorOrNullBehavior(Property.ofValue((Object)FilterItems.ErrorOrNullBehavior.INCLUDE)).build();
        FilterItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)2L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)4L, (Long)output.getProcessedItemsTotal());
        FilterItemsTest.assertFile(runContext, output, List.of(new KeyValue("k2", "dummy"), new KeyValue("k4", 4)), KeyValue.class);
    }

    @Test
    void shouldFilterGivenInvalidRecordsForExclude() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_INVALID_ITEMS, runContext).toString())).filterCondition(" {{ value % 2 == 0 }}").filterType(Property.ofValue((Object)FilterItems.FilterType.INCLUDE)).errorOrNullBehavior(Property.ofValue((Object)FilterItems.ErrorOrNullBehavior.EXCLUDE)).build();
        FilterItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)3L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)4L, (Long)output.getProcessedItemsTotal());
        FilterItemsTest.assertFile(runContext, output, List.of(new KeyValue("k4", 4)), KeyValue.class);
    }

    @Test
    void shouldFilterWithNotMatchGivenNonBooleanValue() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        FilterItems task = FilterItems.builder().from(Property.ofValue((Object)this.generateKeyValueFile(TEST_VALID_ITEMS, runContext).toString())).filterCondition("{{ value }}").filterType(Property.ofValue((Object)FilterItems.FilterType.INCLUDE)).errorOrNullBehavior(Property.ofValue((Object)FilterItems.ErrorOrNullBehavior.FAIL)).build();
        FilterItems.Output output = task.run(runContext);
        Assertions.assertNotNull((Object)output);
        Assertions.assertNotNull((Object)output.getUri());
        Assertions.assertEquals((long)0L, (Long)output.getDroppedItemsTotal());
        Assertions.assertEquals((long)4L, (Long)output.getProcessedItemsTotal());
        FilterItemsTest.assertFile(runContext, output, TEST_VALID_ITEMS, KeyValue.class);
    }

    private static <T> void assertFile(RunContext runContext, FilterItems.Output output, List<T> expected, Class<T> type) throws IOException {
        try (InputStream resource = runContext.storage().getFile(output.getUri());
             InputStreamReader inputStreamReader = new InputStreamReader(resource, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            List<Object> list = bufferedReader.lines().map(line -> {
                try {
                    return JacksonMapper.ofIon().readValue(line, type);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }).toList();
            Assertions.assertEquals(expected, list);
        }
    }

    private URI generateKeyValueFile(List<?> items, RunContext runContext) throws IOException {
        Path path = runContext.workingDir().createTempFile(".ion");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            items.forEach(object -> {
                try {
                    writer.write(JacksonMapper.ofIon().writeValueAsString(object));
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return runContext.storage().putFile(path.toFile());
    }

    record KeyValue(String key, Object value) {
    }
}

