/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.storage.ConcatTest;
import io.kestra.plugin.core.storage.LocalFiles;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class LocalFilesTest {
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    LocalFilesTest() {
    }

    private URI internalFiles(String tenantId) throws IOException, URISyntaxException {
        URL resource = ConcatTest.class.getClassLoader().getResource("application-test.yml");
        return this.storageInterface.put(tenantId, null, new URI("/file/storage/get.yml"), (InputStream)new FileInputStream(Objects.requireNonNull(resource).getFile()));
    }

    @Test
    void run() throws Exception {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        RunContext runContext = this.runContextFactory.of("namesapce", tenant, Map.of("toto", "tata"));
        URI storageFile = this.internalFiles(tenant);
        LocalFiles task = ((LocalFiles.LocalFilesBuilder)((LocalFiles.LocalFilesBuilder)LocalFiles.builder().id(IdUtils.create())).type(LocalFiles.class.getName())).inputs(Map.of("hello-input.txt", "Hello Input", "execution.txt", "{{toto}}", "application-test.yml", storageFile.toString())).outputs(Property.ofValue(List.of("hello-input.txt"))).build();
        LocalFiles.LocalFilesOutput outputs = task.run(runContext);
        Assertions.assertThat((Object)outputs).isNotNull();
        Assertions.assertThat((Map)outputs.getUris()).isNotNull();
        Assertions.assertThat((int)outputs.getUris().size()).isEqualTo(1);
        Assertions.assertThat((String)new String(this.storageInterface.get(tenant, null, (URI)outputs.getUris().get("hello-input.txt")).readAllBytes())).isEqualTo("Hello Input");
        Assertions.assertThat((int)runContext.workingDir().path().toFile().list().length).isEqualTo(2);
        Assertions.assertThat((String)Files.readString(runContext.workingDir().path().resolve("execution.txt"))).isEqualTo("tata");
        Assertions.assertThat((String)Files.readString(runContext.workingDir().path().resolve("application-test.yml"))).isEqualTo(new String(this.storageInterface.get(tenant, null, storageFile).readAllBytes()));
        runContext.cleanup();
    }

    @Test
    void recursive() throws Exception {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        RunContext runContext = this.runContextFactory.of("namesapce", tenant, Map.of("toto", "tata"));
        URI storageFile = this.internalFiles(tenant);
        LocalFiles task = ((LocalFiles.LocalFilesBuilder)((LocalFiles.LocalFilesBuilder)LocalFiles.builder().id(IdUtils.create())).type(LocalFiles.class.getName())).inputs(Map.of("test/hello-input.txt", "Hello Input", "test/sub/dir/2/execution.txt", "{{toto}}", "test/sub/dir/3/application-test.yml", storageFile.toString())).outputs(Property.ofValue(List.of("test/**"))).build();
        LocalFiles.LocalFilesOutput outputs = task.run(runContext);
        Assertions.assertThat((Object)outputs).isNotNull();
        Assertions.assertThat((Map)outputs.getUris()).isNotNull();
        Assertions.assertThat((int)outputs.getUris().size()).isEqualTo(3);
        Assertions.assertThat((String)new String(this.storageInterface.get(tenant, null, (URI)outputs.getUris().get("test/hello-input.txt")).readAllBytes())).isEqualTo("Hello Input");
        Assertions.assertThat((String)new String(this.storageInterface.get(tenant, null, (URI)outputs.getUris().get("test/sub/dir/2/execution.txt")).readAllBytes())).isEqualTo("tata");
        Assertions.assertThat((String)new String(this.storageInterface.get(tenant, null, (URI)outputs.getUris().get("test/sub/dir/3/application-test.yml")).readAllBytes())).isEqualTo(new String(this.storageInterface.get(tenant, null, storageFile).readAllBytes()));
        runContext.cleanup();
    }

    @Test
    void failWithExistingInputFile() throws IOException {
        RunContext runContext = this.runContextFactory.of();
        Files.createFile(Path.of(runContext.workingDir().path().toString(), "hello-input.txt"), new FileAttribute[0]);
        LocalFiles task = ((LocalFiles.LocalFilesBuilder)((LocalFiles.LocalFilesBuilder)LocalFiles.builder().id(IdUtils.create())).type(LocalFiles.class.getName())).inputs(Map.of("hello-input.txt", "Hello Input", "execution.txt", "{{toto}}")).build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalVariableEvaluationException.class, () -> task.run(runContext));
    }
}

