/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.storage.PurgeCurrentExecutionFiles;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class PurgeCurrentExecutionFilesTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    PurgeCurrentExecutionFilesTest() {
    }

    @Test
    void run() throws Exception {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("namespace")).id("flowId")).tenantId("main")).build();
        RunContext runContext = this.runContextFactory.of(flow, Map.of("execution", Map.of("id", "executionId"), "task", Map.of("id", "taskId"), "taskrun", Map.of("id", "taskRunId")));
        Path file = runContext.workingDir().createFile("test.txt", "Hello World".getBytes());
        runContext.storage().putFile(file.toFile());
        PurgeCurrentExecutionFiles purge = PurgeCurrentExecutionFiles.builder().build();
        PurgeCurrentExecutionFiles.Output output = purge.run(runContext);
        Assertions.assertThat((int)output.getUris().size()).isEqualTo(2);
    }
}

