/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.google.common.io.CharStreams;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.Reverse;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ReverseTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    ReverseTest() {
    }

    @Test
    void run() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URI put = this.storageInterface.put("main", null, new URI("/file/storage/get.yml"), (InputStream)new ByteArrayInputStream("1\n2\n3\n".getBytes()));
        Reverse result = Reverse.builder().from(Property.ofValue((Object)put.toString())).build();
        Reverse.Output run = result.run(runContext);
        Assertions.assertThat((String)run.getUri().getPath()).endsWith((CharSequence)".yml");
        Assertions.assertThat((String)CharStreams.toString((Readable)new InputStreamReader(this.storageInterface.get("main", null, run.getUri())))).isEqualTo("3\n2\n1\n");
    }
}

