/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.Size;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SizeTest {
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    SizeTest() {
    }

    @Test
    void run() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        Long size = 42L;
        byte[] randomBytes = new byte[size.intValue()];
        new Random().nextBytes(randomBytes);
        URI put = this.storageInterface.put("main", null, new URI("/file/storage/get.yml"), (InputStream)new ByteArrayInputStream(randomBytes));
        Size bash = Size.builder().uri(Property.ofValue((Object)put.toString())).build();
        Size.Output run = bash.run(runContext);
        Assertions.assertThat((Long)run.getSize()).isEqualTo((Object)size);
    }
}

