/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import com.google.common.io.CharStreams;
import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.core.storage.Split;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class SplitTest {
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    SplitTest() {
    }

    @Test
    void partition() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URI put = this.storageUpload(1000);
        Split result = Split.builder().from(Property.ofValue((Object)put.toString())).partitions(Property.ofValue((Object)8)).build();
        Split.Output run = result.run(runContext);
        Assertions.assertThat((int)run.getUris().size()).isEqualTo(8);
        Assertions.assertThat((String)((URI)run.getUris().getFirst()).getPath()).endsWith((CharSequence)".yml");
        Assertions.assertThat((int)StringUtils.countMatches((CharSequence)this.readAll(run.getUris()), (CharSequence)"\n")).isEqualTo(1000);
    }

    @Test
    void rows() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URI put = this.storageUpload(1000);
        Split result = Split.builder().from(Property.ofValue((Object)put.toString())).rows(Property.ofValue((Object)10)).build();
        Split.Output run = result.run(runContext);
        Assertions.assertThat((int)run.getUris().size()).isEqualTo(100);
        Assertions.assertThat((String)this.readAll(run.getUris())).isEqualTo(String.join((CharSequence)"\n", this.content(1000)) + "\n");
    }

    @Test
    void bytes() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URI put = this.storageUpload(12288);
        Split result = Split.builder().from(Property.ofValue((Object)put.toString())).bytes(Property.ofValue((Object)"1KB")).build();
        Split.Output run = result.run(runContext);
        Assertions.assertThat((int)run.getUris().size()).isEqualTo(251);
        Assertions.assertThat((String)this.readAll(run.getUris())).isEqualTo(String.join((CharSequence)"\n", this.content(12288)) + "\n");
    }

    @Test
    void regexPattern() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        URI put = this.storageUploadWithRegexContent();
        Split result = Split.builder().from(Property.ofValue((Object)put.toString())).regexPattern(Property.ofValue((Object)"\\[(\\w+)\\]")).build();
        Split.Output run = result.run(runContext);
        Assertions.assertThat((int)run.getUris().size()).isEqualTo(3);
        String allContent = this.readAll(run.getUris());
        Assertions.assertThat((String)allContent).contains(new CharSequence[]{"[ERROR] Error message 1"});
        Assertions.assertThat((String)allContent).contains(new CharSequence[]{"[WARN] Warning message 1"});
        Assertions.assertThat((String)allContent).contains(new CharSequence[]{"[INFO] Info message 1"});
        Assertions.assertThat((String)allContent).contains(new CharSequence[]{"[ERROR] Error message 2"});
    }

    private List<String> content(int count) {
        return IntStream.range(0, count).mapToObj(value -> StringUtils.leftPad((String)("" + value), (int)20)).toList();
    }

    private String readAll(List<URI> uris) throws IOException {
        return uris.stream().map(Rethrow.throwFunction(uri -> CharStreams.toString((Readable)new InputStreamReader(this.storageInterface.get("main", null, uri))))).collect(Collectors.joining());
    }

    URI storageUpload(int count) throws URISyntaxException, IOException {
        File tempFile = File.createTempFile("unit", "");
        Files.write(tempFile.toPath(), this.content(count), new OpenOption[0]);
        return this.storageInterface.put("main", null, new URI("/file/storage/%s/get.yml".formatted(IdUtils.create())), (InputStream)new FileInputStream(tempFile));
    }

    URI storageUploadWithRegexContent() throws URISyntaxException, IOException {
        File tempFile = File.createTempFile("unit", "");
        List<String> regexContent = List.of("[ERROR] Error message 1", "[WARN] Warning message 1", "[INFO] Info message 1", "[ERROR] Error message 2", "[WARN] Warning message 2", "[INFO] Info message 2", "Line without pattern", "[ERROR] Error message 3");
        Files.write(tempFile.toPath(), regexContent, new OpenOption[0]);
        return this.storageInterface.put("main", null, new URI("/file/storage/%s/get.yml".formatted(IdUtils.create())), (InputStream)new FileInputStream(tempFile));
    }
}

