/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.StorageInterface;
import io.kestra.plugin.core.storage.Write;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class WriteTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;

    WriteTest() {
    }

    @Test
    void run() throws Exception {
        RunContext runContext = this.runContextFactory.of();
        Write write = Write.builder().content(Property.ofValue((Object)"Hello World")).extension(Property.ofValue((Object)".txt")).build();
        Write.Output output = write.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat((URI)output.getUri()).isNotNull();
        InputStream inputStream = this.storageInterface.get("main", null, output.getUri());
        Assertions.assertThat((InputStream)inputStream).isNotNull();
        inputStream.close();
    }
}

