/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.templating;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.templating.TemplatedTask;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class TemplatedTaskTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    TemplatedTaskTest() {
    }

    @Test
    void templatedType() throws Exception {
        RunContext runContext = this.runContextFactory.of(Map.of("type", "io.kestra.plugin.core.debug.Return"));
        TemplatedTask templatedTask = ((TemplatedTask.TemplatedTaskBuilder)((TemplatedTask.TemplatedTaskBuilder)TemplatedTask.builder().id("template")).type(TemplatedTask.class.getName())).spec(Property.ofExpression((String)"type: {{ type }}\nformat: It's alive!")).build();
        Output output = templatedTask.run(runContext);
        Assertions.assertThat((Object)output).isNotNull();
        Assertions.assertThat((Object)output).isInstanceOf(Return.Output.class);
        Assertions.assertThat((String)((Return.Output)output).getValue()).isEqualTo("It's alive!");
    }

    @Test
    void templatedFlowable() {
        RunContext runContext = this.runContextFactory.of();
        TemplatedTask templatedTask = ((TemplatedTask.TemplatedTaskBuilder)((TemplatedTask.TemplatedTaskBuilder)TemplatedTask.builder().id("template")).type(TemplatedTask.class.getName())).spec(Property.ofValue((Object)"type: io.kestra.plugin.core.flow.Pause\ndelay: PT10S")).build();
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> templatedTask.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("The templated task must be a runnable task");
    }

    @Test
    void templatedTemplated() {
        RunContext runContext = this.runContextFactory.of();
        TemplatedTask templatedTask = ((TemplatedTask.TemplatedTaskBuilder)((TemplatedTask.TemplatedTaskBuilder)TemplatedTask.builder().id("template")).type(TemplatedTask.class.getName())).spec(Property.ofValue((Object)"type: io.kestra.plugin.core.templating.TemplatedTask\nspec: whatever")).build();
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> templatedTask.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("The templated task cannot be of type 'io.kestra.plugin.core.templating.TemplatedTask'");
    }
}

