/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    Optional<MultipleConditionStorageInterface> multipleConditionStorage;

    FlowTest() {
    }

    @Test
    void success() {
        io.kestra.core.models.flows.Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.core.models.flows.Flow.builder().id("flow-with-flow-trigger")).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).labels(List.of(new Label("flow-label-1", "flow-label-1"), new Label("flow-label-2", "flow-label-2")))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).build();
        Execution execution = Execution.builder().id(IdUtils.create()).namespace("io.kestra.unittest").flowId("flow-with-flow-trigger").flowRevision(Integer.valueOf(1)).state(State.of((State.Type)State.Type.RUNNING, Collections.emptyList())).labels(List.of(new Label("execution-label", "execution"), new Label("system.correlationId", "correlationId"))).build();
        Flow flowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow")).type(Flow.class.getName())).build();
        Optional evaluate = flowTrigger.evaluate(this.multipleConditionStorage, this.runContextFactory.of(), flow, execution);
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((String)((Execution)evaluate.get()).getFlowId()).isEqualTo("flow-with-flow-trigger");
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).hasSize(3);
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-1", "flow-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-2", "flow-label-2")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("system.correlationId", "correlationId")});
    }

    @Test
    void withTenant() {
        io.kestra.core.models.flows.Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.core.models.flows.Flow.builder().id("flow-with-flow-trigger")).tenantId("tenantId")).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).labels(List.of(new Label("flow-label-1", "flow-label-1"), new Label("flow-label-2", "flow-label-2")))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).build();
        Execution execution = Execution.builder().id(IdUtils.create()).tenantId("tenantId").namespace("io.kestra.unittest").flowId("flow-with-flow-trigger").flowRevision(Integer.valueOf(1)).state(State.of((State.Type)State.Type.RUNNING, Collections.emptyList())).labels(List.of(new Label("execution-label", "execution"), new Label("system.correlationId", "correlationId"))).build();
        Flow flowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow")).type(Flow.class.getName())).build();
        Optional evaluate = flowTrigger.evaluate(this.multipleConditionStorage, this.runContextFactory.of(), flow, execution);
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((String)((Execution)evaluate.get()).getFlowId()).isEqualTo("flow-with-flow-trigger");
        Assertions.assertThat((String)((Execution)evaluate.get()).getTenantId()).isEqualTo("tenantId");
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).hasSize(3);
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-1", "flow-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-2", "flow-label-2")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("system.correlationId", "correlationId")});
    }

    @Test
    void success_withLabels() {
        io.kestra.core.models.flows.Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.core.models.flows.Flow.builder().id("flow-with-flow-trigger")).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).labels(List.of(new Label("flow-label-1", "flow-label-1"), new Label("flow-label-2", "flow-label-2")))).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).build();
        Execution execution = Execution.builder().id(IdUtils.create()).namespace("io.kestra.unittest").flowId("flow-with-flow-trigger").flowRevision(Integer.valueOf(1)).state(State.of((State.Type)State.Type.RUNNING, Collections.emptyList())).labels(List.of(new Label("execution-label", "execution"), new Label("system.correlationId", "correlationId"))).build();
        Flow flowTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id("flow")).type(Flow.class.getName())).labels(List.of(new Label("trigger-label-1", "trigger-label-1"), new Label("trigger-label-2", "{{ 'trigger-label-2' }}"), new Label("trigger-label-3", "{{ null }}"), new Label("trigger-label-4", "{{ foobar }}")))).build();
        Optional evaluate = flowTrigger.evaluate(this.multipleConditionStorage, this.runContextFactory.of(), flow, execution);
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).hasSize(5);
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-1", "flow-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-2", "flow-label-2")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("trigger-label-1", "trigger-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("trigger-label-2", "trigger-label-2")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).doesNotContain((Object[])new Label[]{new Label("trigger-label-3", "")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("system.correlationId", "correlationId")});
        Assertions.assertThat((Object)((Execution)evaluate.get()).getTrigger()).extracting(ExecutionTrigger::getVariables).hasFieldOrProperty("executionLabels");
        Assertions.assertThat(((Execution)evaluate.get()).getTrigger().getVariables().get("executionLabels")).isEqualTo(Map.of("execution-label", "execution"));
    }
}

