/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.trigger.ScheduleOnDates;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ScheduleOnDatesTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    RunContextInitializer runContextInitializer;

    ScheduleOnDatesTest() {
    }

    @Test
    public void shouldReturnNextDateWhenNextEvaluationDateAndAnExistingTriggerDate() throws Exception {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime before = now.minusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime after = now.plusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime later = now.plusMinutes(2L).truncatedTo(ChronoUnit.SECONDS);
        ScheduleOnDates scheduleOnDates = ((ScheduleOnDates.ScheduleOnDatesBuilder)((ScheduleOnDates.ScheduleOnDatesBuilder)ScheduleOnDates.builder().id(IdUtils.create())).type(ScheduleOnDates.class.getName())).interval(null).dates(Property.ofValue(List.of(before, after, later))).build();
        TriggerContext triggerContext = TriggerContext.builder().date(now).build();
        Trigger trigger = Trigger.of((TriggerContext)triggerContext, (ZonedDateTime)now);
        ConditionContext conditionContext = this.conditionContext((AbstractTrigger)scheduleOnDates);
        ZonedDateTime nextDate = scheduleOnDates.nextEvaluationDate(conditionContext, Optional.of(trigger));
        Assertions.assertThat((ZonedDateTime)nextDate).isEqualTo((Object)after);
    }

    @Test
    public void shouldReturnFirstDateWhenNextEvaluationDateAndNoExistingTriggerDate() throws Exception {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime before = now.minusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime after = now.plusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime later = now.plusMinutes(2L).truncatedTo(ChronoUnit.SECONDS);
        ScheduleOnDates scheduleOnDates = ((ScheduleOnDates.ScheduleOnDatesBuilder)((ScheduleOnDates.ScheduleOnDatesBuilder)ScheduleOnDates.builder().id(IdUtils.create())).type(ScheduleOnDates.class.getName())).interval(null).dates(Property.ofValue(List.of(before, after, later))).build();
        ConditionContext conditionContext = this.conditionContext((AbstractTrigger)scheduleOnDates);
        ZonedDateTime nextDate = scheduleOnDates.nextEvaluationDate(conditionContext, Optional.empty());
        Assertions.assertThat((ZonedDateTime)nextDate).isEqualTo((Object)before);
    }

    @Test
    public void shouldReturnPreviousDateWhenPreviousEvaluationDate() throws Exception {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime first = now.minusMinutes(2L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime before = now.minusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime next = now.plusMinutes(1L).truncatedTo(ChronoUnit.SECONDS);
        ScheduleOnDates scheduleOnDates = ((ScheduleOnDates.ScheduleOnDatesBuilder)((ScheduleOnDates.ScheduleOnDatesBuilder)ScheduleOnDates.builder().id(IdUtils.create())).type(ScheduleOnDates.class.getName())).interval(null).dates(Property.ofValue(List.of(first, before, next))).build();
        ConditionContext conditionContext = this.conditionContext((AbstractTrigger)scheduleOnDates);
        ZonedDateTime previousDate = scheduleOnDates.previousEvaluationDate(conditionContext);
        Assertions.assertThat((ZonedDateTime)previousDate).isEqualTo((Object)before);
    }

    private ConditionContext conditionContext(AbstractTrigger trigger) {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace("io.kestra.tests")).labels(List.of(new Label("flow-label-1", "flow-label-1"), new Label("flow-label-2", "flow-label-2")))).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input1")).type(Type.STRING)).required(Boolean.valueOf(false))).build(), ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).type(Type.STRING)).defaults(Property.ofValue((Object)"default"))).build()))).build();
        TriggerContext triggerContext = TriggerContext.builder().namespace(flow.getNamespace()).flowId(flow.getId()).triggerId(trigger.getId()).build();
        return ConditionContext.builder().runContext((RunContext)this.runContextInitializer.forScheduler((DefaultRunContext)this.runContextFactory.of(), triggerContext, trigger)).flow((FlowInterface)flow).build();
    }
}

