/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Backfill;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.RunContextInitializer;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.condition.DateTimeBetween;
import io.kestra.plugin.core.condition.DayWeekInMonth;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ScheduleTest {
    private static final String TEST_CRON_EVERYDAY_AT_8 = "0 8 * * *";
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    RunContextInitializer runContextInitializer;

    ScheduleTest() {
    }

    @Test
    void failed() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("1 1 1 1 1").build();
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), TriggerContext.builder().date(ZonedDateTime.now().withSecond(2)).build());
        Assertions.assertThat((boolean)evaluate.isPresent()).isFalse();
    }

    private static TriggerContext triggerContext(ZonedDateTime date, Schedule schedule) {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).variables(Map.of("custom_var", "VARIABLE VALUE")).tasks(Collections.singletonList(((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("test")).type(Return.class.getName())).format(Property.ofValue((Object)"test")).build())).build();
        return TriggerContext.builder().namespace(flow.getNamespace()).flowId(flow.getNamespace()).triggerId(schedule.getId()).date(date).build();
    }

    @Test
    void success() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("0 0 1 * *").build();
        ZonedDateTime date = ZonedDateTime.now().withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).truncatedTo(ChronoUnit.SECONDS).minusMonths(1L);
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).hasSize(3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Execution)evaluate.get()).getLabels().stream().anyMatch(label -> label.key().equals("system.correlationId")));
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Map inputs = ((Execution)evaluate.get()).getInputs();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), date)).isEqualTo((Object)date.plusMonths(1L));
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), date)).isEqualTo((Object)date.minusMonths(1L));
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-1", "flow-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("flow-label-2", "flow-label-2")});
        Assertions.assertThat((int)inputs.size()).isEqualTo(2);
        Assertions.assertThat(inputs.get("input1")).isNull();
        Assertions.assertThat(inputs.get("input2")).isEqualTo((Object)"default");
    }

    @Test
    void successWithInput() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("0 0 1 * *").inputs(Map.of("input1", "input1")).build();
        ZonedDateTime date = ZonedDateTime.now().withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).truncatedTo(ChronoUnit.SECONDS).minusMonths(1L);
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).hasSize(3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Execution)evaluate.get()).getLabels().stream().anyMatch(label -> label.key().equals("system.correlationId")));
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map inputs = ((Execution)evaluate.get()).getInputs();
        Assertions.assertThat((int)inputs.size()).isEqualTo(2);
        Assertions.assertThat(inputs.get("input1")).isEqualTo((Object)"input1");
        Assertions.assertThat(inputs.get("input2")).isEqualTo((Object)"default");
    }

    @Test
    void success_withLabels() throws Exception {
        Schedule scheduleTrigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("0 0 1 * *").labels(List.of(new Label("trigger-label-1", "trigger-label-1"), new Label("trigger-label-2", "{{ 'trigger-label-2' }}"), new Label("trigger-label-3", "{{ null }}")))).build();
        ConditionContext conditionContext = this.conditionContext((AbstractTrigger)scheduleTrigger);
        ZonedDateTime date = ZonedDateTime.now().withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).truncatedTo(ChronoUnit.SECONDS).minusMonths(1L);
        TriggerContext triggerContext = ScheduleTest.triggerContext(date, scheduleTrigger);
        Optional evaluate = scheduleTrigger.evaluate(conditionContext, triggerContext);
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("trigger-label-1", "trigger-label-1")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).contains((Object[])new Label[]{new Label("trigger-label-2", "trigger-label-2")});
        Assertions.assertThat((List)((Execution)evaluate.get()).getLabels()).doesNotContain((Object[])new Label[]{new Label("trigger-label-3", "")});
    }

    @Test
    void everyMinute() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("* * * * *").build();
        ZonedDateTime date = ZonedDateTime.now().minus(Duration.ofMinutes(1L)).withSecond(0).truncatedTo(ChronoUnit.SECONDS).plus(Duration.ofMinutes(1L));
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), date)).isEqualTo((Object)date.plus(Duration.ofMinutes(1L)));
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), date)).isEqualTo((Object)date.minus(Duration.ofMinutes(1L)));
    }

    @Test
    void everySecond() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("* * * * * *").withSeconds(Boolean.valueOf(true)).build();
        ZonedDateTime date = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS).minus(Duration.ofSeconds(1L));
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), date)).isEqualTo((Object)date.plus(Duration.ofSeconds(1L)));
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), date)).isEqualTo((Object)date.minus(Duration.ofSeconds(1L)));
    }

    @Test
    void shouldNotReturnExecutionForBackFillWhenCurrentDateIsBeforeScheduleDate() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron(TEST_CRON_EVERYDAY_AT_8).build();
        ZonedDateTime now = ZonedDateTime.now();
        TriggerContext triggerContext = ScheduleTest.triggerContext(now, trigger).toBuilder().backfill(Backfill.builder().currentDate(ZonedDateTime.now().with(LocalTime.MIN)).end(ZonedDateTime.now().with(LocalTime.MAX)).build()).build();
        Optional result = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), triggerContext);
        Assertions.assertThat((boolean)result.isEmpty()).isTrue();
    }

    @Test
    void shouldReturnExecutionForBackFillWhenCurrentDateIsAfterScheduleDate() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron(TEST_CRON_EVERYDAY_AT_8).build();
        ZonedDateTime now = ZonedDateTime.of(2025, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault());
        TriggerContext triggerContext = ScheduleTest.triggerContext(ZonedDateTime.now(), trigger).toBuilder().backfill(Backfill.builder().currentDate(now.with(LocalTime.MIN).plus(Duration.ofHours(8L))).end(now.with(LocalTime.MAX)).build()).build();
        Optional result = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), triggerContext);
        Assertions.assertThat((boolean)result.isPresent()).isTrue();
    }

    @Test
    void noBackfillNextDate() {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("0 0 * * *").build();
        ZonedDateTime next = trigger.nextEvaluationDate(this.conditionContext((AbstractTrigger)trigger), Optional.empty());
        Assertions.assertThat((int)next.getDayOfMonth()).isEqualTo(ZonedDateTime.now().plusDays(1L).getDayOfMonth());
    }

    @Test
    void noBackfillNextDateContext() {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("0 0 * * *").timezone("Europe/Paris").build();
        ZonedDateTime date = ZonedDateTime.parse("2020-01-01T00:00:00+01:00[Europe/Paris]");
        ZonedDateTime next = trigger.nextEvaluationDate(this.conditionContext((AbstractTrigger)trigger), Optional.of(ScheduleTest.triggerContext(date, trigger)));
        Assertions.assertThat((String)next.format(DateTimeFormatter.ISO_LOCAL_DATE)).isEqualTo(date.plusDays(1L).format(DateTimeFormatter.ISO_LOCAL_DATE));
    }

    @Test
    void systemBackfillChangedFromCronExpression() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("30 0 1 * *").build();
        ZonedDateTime date = ZonedDateTime.now().withDayOfMonth(1).withHour(0).withMinute(45).withSecond(0).truncatedTo(ChronoUnit.SECONDS).minusMonths(1L);
        ZonedDateTime expexted = date.withMinute(30).plusMonths(1L);
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), expexted)).isEqualTo((Object)expexted);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), expexted)).isEqualTo((Object)expexted.plusMonths(1L));
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), expexted)).isEqualTo((Object)expexted.minusMonths(1L));
    }

    @Test
    void conditions() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).type(Schedule.class.getName())).cron("0 12 * * 1").timezone("Europe/Paris").conditions(List.of(((DayWeekInMonth.DayWeekInMonthBuilder)DayWeekInMonth.builder().type(DayWeekInMonth.class.getName())).dayOfWeek(Property.ofValue((Object)DayOfWeek.MONDAY)).dayInMonth(Property.ofValue((Object)DayWeekInMonth.DayInMonth.FIRST)).date("{{ trigger.date }}").build()))).build();
        ZonedDateTime date = ZonedDateTime.parse("2021-08-02T12:00:00+02:00");
        ZonedDateTime previous = ZonedDateTime.parse("2021-07-05T12:00:00+02:00");
        ZonedDateTime next = ZonedDateTime.parse("2021-09-06T12:00:00+02:00");
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), next)).isEqualTo((Object)next);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), previous)).isEqualTo((Object)previous);
    }

    @Test
    void impossibleNextConditions() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).type(Schedule.class.getName())).cron("0 12 * * 1").timezone("Europe/Paris").conditions(List.of(((DateTimeBetween.DateTimeBetweenBuilder)DateTimeBetween.builder().type(DateTimeBetween.class.getName())).before(Property.ofValue((Object)ZonedDateTime.parse("2021-08-03T12:00:00+02:00"))).date("{{ trigger.date }}").build()))).build();
        ZonedDateTime date = ZonedDateTime.parse("2021-08-02T12:00:00+02:00");
        ZonedDateTime previous = ZonedDateTime.parse("2021-07-26T12:00:00+02:00");
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), previous)).isEqualTo((Object)previous);
        Assertions.assertThat((boolean)vars.containsKey("next")).isFalse();
    }

    @Test
    void lateMaximumDelay() {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("* * * * *").lateMaximumDelay(Duration.ofMinutes(5L)).build();
        ZonedDateTime date = ZonedDateTime.now().minusMinutes(15L);
        ZonedDateTime expected = ZonedDateTime.now().minusMinutes(4L).withSecond(0).truncatedTo(ChronoUnit.SECONDS);
        ZonedDateTime evaluate = trigger.nextEvaluationDate(this.conditionContext((AbstractTrigger)trigger), Optional.of(TriggerContext.builder().date(date).build()));
        Assertions.assertThat((ZonedDateTime)evaluate).isEqualTo((Object)expected);
    }

    @Test
    void hourly() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("@hourly").build();
        ZonedDateTime date = ZonedDateTime.now().minusHours(1L).withMinute(0).withSecond(0).withNano(0);
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), TriggerContext.builder().date(date).namespace("io.kestra.tests").flowId(IdUtils.create()).build());
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
    }

    @Test
    void timezone() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron("12 9 1 * *").timezone("America/New_York").build();
        ZonedDateTime date = ZonedDateTime.now().withZoneSameLocal(ZoneId.of("America/New_York")).withMonth(5).withDayOfMonth(1).withHour(9).withMinute(12).withSecond(0).withYear(2022).truncatedTo(ChronoUnit.SECONDS).minusMonths(1L);
        Optional evaluate = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), ScheduleTest.triggerContext(date, trigger));
        Assertions.assertThat((boolean)evaluate.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)evaluate.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
        Map vars = ((Execution)evaluate.get()).getTrigger().getVariables();
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("date"), date)).isEqualTo((Object)date);
        Assertions.assertThat((String)ZonedDateTime.parse((String)vars.get("date")).getZone().getId()).isEqualTo("-04:00");
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("next"), date)).isEqualTo((Object)date.plusMonths(1L));
        Assertions.assertThat((ZonedDateTime)this.dateFromVars((String)vars.get("previous"), date)).isEqualTo((Object)date.minusMonths(1L));
    }

    @Test
    void timezone_with_backfile() throws Exception {
        Schedule trigger = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id("schedule")).type(Schedule.class.getName())).cron(TEST_CRON_EVERYDAY_AT_8).timezone("America/New_York").build();
        TriggerContext triggerContext = ScheduleTest.triggerContext(ZonedDateTime.now(), trigger).toBuilder().backfill(Backfill.builder().currentDate(ZonedDateTime.parse("2025-01-15T08:00-05:00[America/New_York]")).end(ZonedDateTime.parse("2025-01-16T07:00-05:00[America/New_York]")).build()).build();
        Optional result = trigger.evaluate(this.conditionContext((AbstractTrigger)trigger), triggerContext);
        Assertions.assertThat((boolean)result.isPresent()).isTrue();
        Assertions.assertThat((Map)((Execution)result.get()).getVariables()).containsEntry((Object)"custom_var", (Object)"VARIABLE VALUE");
    }

    private ConditionContext conditionContext(AbstractTrigger trigger) {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace("io.kestra.tests")).labels(List.of(new Label("flow-label-1", "flow-label-1"), new Label("flow-label-2", "flow-label-2")))).variables(Map.of("custom_var", "VARIABLE VALUE")).inputs(List.of(((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input1")).type(Type.STRING)).required(Boolean.valueOf(false))).build(), ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("input2")).type(Type.STRING)).defaults(Property.ofValue((Object)"default"))).build()))).build();
        TriggerContext triggerContext = TriggerContext.builder().namespace(flow.getNamespace()).flowId(flow.getId()).triggerId(trigger.getId()).build();
        return ConditionContext.builder().runContext((RunContext)this.runContextInitializer.forScheduler((DefaultRunContext)this.runContextFactory.of(), triggerContext, trigger)).flow((FlowInterface)flow).build();
    }

    private ZonedDateTime dateFromVars(String date, ZonedDateTime expexted) {
        return ZonedDateTime.parse(date).withZoneSameInstant(expexted.getZone());
    }
}

