/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.TestsUtils;
import io.kestra.scheduler.AbstractScheduler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true, startScheduler=true)
class ToggleTest {
    @Inject
    private TriggerRepositoryInterface triggerRepository;
    @Inject
    @Named(value="triggerQueue")
    private QueueInterface<Trigger> triggerQueue;
    @Inject
    private AbstractScheduler scheduler;
    @Inject
    private TestRunnerUtils runnerUtils;

    ToggleTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/trigger-toggle.yaml"})
    void toggle() throws Exception {
        Await.until(() -> this.scheduler.isReady(), (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(20L));
        Trigger trigger = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().triggerId("schedule")).flowId("trigger-toggle")).namespace("io.kestra.tests.trigger")).date(ZonedDateTime.now())).disabled(Boolean.valueOf(true))).build();
        this.triggerRepository.save(trigger);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Flux receive = TestsUtils.receive(this.triggerQueue, either -> {
            if (either.isLeft()) {
                countDownLatch.countDown();
            }
        });
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests.trigger", "trigger-toggle");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        countDownLatch.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)countDownLatch.getCount()).isEqualTo(0L);
        Trigger lastTrigger = (Trigger)receive.blockLast();
        Assertions.assertThat((Object)lastTrigger).isNotNull();
        Assertions.assertThat((Boolean)lastTrigger.getDisabled()).isFalse();
    }
}

