/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.retry.intercept;

import io.kestra.core.annotations.Retryable;
import io.kestra.core.junit.annotations.KestraTest;
import io.micronaut.retry.event.RetryEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.nio.channels.AlreadyBoundException;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KestraTest
class OverrideRetryInterceptorTest {
    @Inject
    RetryEvents retryEvents;
    @Inject
    TestRetry retry;

    OverrideRetryInterceptorTest() {
    }

    @Test
    void test() {
        org.junit.jupiter.api.Assertions.assertThrows(AlreadyBoundException.class, this.retry::failedMethod);
        Assertions.assertThat((int)this.retryEvents.count).isEqualTo(5);
    }

    @Singleton
    public static class TestRetry {
        @Retryable(delay="10ms", multiplier="2.0")
        public String failedMethod() {
            throw new AlreadyBoundException();
        }
    }

    @Singleton
    public static class RetryEvents {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(RetryEvents.class);
        public int count = 0;

        @EventListener
        void onRetry(RetryEvent event) {
            ++this.count;
        }
    }
}

