/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.executor;

import io.kestra.core.debug.Breakpoint;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.ExecutionKilledExecution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.Concurrency;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.ExecutionUpdatableTask;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.ExecutionDelay;
import io.kestra.core.runners.ExecutionRunning;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionEnd;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerGroupExecutorInterface;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.services.LabelService;
import io.kestra.core.services.LogService;
import io.kestra.core.services.VariablesService;
import io.kestra.core.services.WorkerGroupService;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.test.flow.TaskFixture;
import io.kestra.core.trace.propagation.RunContextTextMapSetter;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.TruthUtils;
import io.kestra.executor.SLAService;
import io.kestra.executor.WorkerJobRunningStateStore;
import io.kestra.plugin.core.flow.LoopUntil;
import io.kestra.plugin.core.flow.Pause;
import io.kestra.plugin.core.flow.Subflow;
import io.kestra.plugin.core.flow.WorkingDirectory;
import io.micronaut.context.ApplicationContext;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class ExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorService.class);
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private RunContextFactory runContextFactory;
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private ConditionService conditionService;
    @Inject
    private LogService logService;
    @Inject
    private FlowInputOutput flowInputOutput;
    @Inject
    private WorkerGroupExecutorInterface workerGroupExecutorInterface;
    @Inject
    private WorkerJobRunningStateStore workerJobRunningStateStore;
    protected FlowMetaStoreInterface flowExecutorInterface;
    @Inject
    private ExecutionService executionService;
    @Inject
    private WorkerGroupService workerGroupService;
    @Inject
    private SLAService slaService;
    @Inject
    private Optional<OpenTelemetry> openTelemetry;
    @Inject
    private VariablesService variablesService;
    @Inject
    @Named(value="executionKilledQueue")
    protected QueueInterface<ExecutionKilled> killQueue;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;

    protected FlowMetaStoreInterface flowExecutorInterface() {
        if (this.flowExecutorInterface == null) {
            this.flowExecutorInterface = (FlowMetaStoreInterface)this.applicationContext.getBean(FlowMetaStoreInterface.class);
        }
        return this.flowExecutorInterface;
    }

    public ExecutionRunning processExecutionRunning(FlowInterface flow, int runningCount, ExecutionRunning executionRunning) {
        if (flow.getConcurrency() != null && runningCount >= flow.getConcurrency().getLimit()) {
            return switch (flow.getConcurrency().getBehavior()) {
                default -> throw new MatchException(null, null);
                case Concurrency.Behavior.QUEUE -> {
                    ExecutionRunning var4_6;
                    this.logService.logExecution(executionRunning.getExecution(), Level.INFO, "Execution is queued due to concurrency limit exceeded, {} running(s)", new Object[]{runningCount});
                    Execution newExecution = executionRunning.getExecution().withState(State.Type.QUEUED);
                    this.metricRegistry.counter("executor.execution.queued.count", "The total number of executions queued by the Executor", this.metricRegistry.tags(newExecution)).increment();
                    yield var4_6 = executionRunning.withExecution(newExecution).withConcurrencyState(ExecutionRunning.ConcurrencyState.QUEUED);
                }
                case Concurrency.Behavior.CANCEL -> {
                    ExecutionRunning var4_7;
                    yield var4_7 = executionRunning.withExecution(executionRunning.getExecution().withState(State.Type.CANCELLED)).withConcurrencyState(ExecutionRunning.ConcurrencyState.RUNNING);
                }
                case Concurrency.Behavior.FAIL -> {
                    ExecutionRunning var4_8;
                    Execution.FailedExecutionWithLog failedExecution = executionRunning.getExecution().failedExecutionFromExecutor((Exception)new IllegalStateException("Execution is FAILED due to concurrency limit exceeded"));
                    try {
                        this.logQueue.emitAsync(failedExecution.getLogs());
                    }
                    catch (QueueException var6_9) {
                        // empty catch block
                    }
                    yield var4_8 = executionRunning.withExecution(failedExecution.getExecution()).withConcurrencyState(ExecutionRunning.ConcurrencyState.RUNNING);
                }
            };
        }
        return executionRunning.withExecution(executionRunning.getExecution().withState(State.Type.RUNNING)).withConcurrencyState(ExecutionRunning.ConcurrencyState.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Executor process(Executor executor) {
        if (!executor.canBeProcessed().booleanValue() || this.executionService.isTerminated((Flow)executor.getFlow(), executor.getExecution())) {
            return executor;
        }
        long nanos = System.nanoTime();
        try {
            executor = this.handleRestart(executor);
            executor = this.handleEnd(executor);
            executor = this.handleCreatedKilling(executor);
            executor = this.handleKilling(executor);
            if (executor.getExecution().getState().getCurrent() != State.Type.KILLING && executor.getExecution().getState().getCurrent() != State.Type.KILLED && executor.getExecution().getState().getCurrent() != State.Type.QUEUED) {
                executor = this.handleNext(executor);
                executor = this.handleChildNext(executor);
            }
            executor = this.handleAfterExecution(executor);
            executor = this.handleWorkerTask(executor);
            executor = this.handleChildWorkerTaskResult(executor);
            executor = this.handleExecutionUpdatingTask(executor);
            executor = this.handleExecutableTask(executor);
        }
        catch (Exception e) {
            Executor executor2 = executor.withException(e, "process");
            return executor2;
        }
        finally {
            this.metricRegistry.timer("executor.execution.message.process", "Duration of a single execution message processed by the Executor", this.metricRegistry.tags(executor.getExecution())).record(Duration.ofNanos(System.nanoTime() - nanos));
        }
        return executor;
    }

    public Execution onNexts(Execution execution, List<TaskRun> nexts) {
        List<TaskRun> executionTasksRun;
        if (log.isTraceEnabled()) {
            this.logService.logExecution(execution, Level.TRACE, "Found {} next(s) {}", new Object[]{nexts.size(), nexts});
        }
        if (execution.getTaskRunList() == null) {
            executionTasksRun = nexts;
        } else {
            executionTasksRun = new ArrayList<TaskRun>(execution.getTaskRunList());
            executionTasksRun.addAll(nexts);
        }
        Execution newExecution = execution.withTaskRunList(executionTasksRun);
        if (execution.getState().getCurrent() == State.Type.CREATED) {
            this.metricRegistry.counter("executor.execution.started.count", "The total number of executions started by the Executor", this.metricRegistry.tags(execution)).increment();
            this.logService.logExecution(execution, Level.INFO, "Flow started", new Object[0]);
            newExecution = newExecution.withState(State.Type.RUNNING);
        }
        return newExecution;
    }

    private Optional<WorkerTaskResult> childWorkerTaskResult(Flow flow, Execution execution, TaskRun parentTaskRun) throws InternalException {
        Task parent = flow.findTaskByTaskId(parentTaskRun.getTaskId());
        if (parent instanceof FlowableTask) {
            Optional<State.Type> state;
            FlowableTask flowableParent = (FlowableTask)parent;
            RunContext runContext = this.runContextFactory.of((FlowInterface)flow, parent, execution, parentTaskRun);
            try {
                state = flowableParent.resolveState(runContext, execution, parentTaskRun);
            }
            catch (Exception e) {
                runContext.logger().error("Unable to resolve state from the Flowable task: {}", (Object)e.getMessage(), (Object)e);
                state = Optional.of(State.Type.FAILED);
            }
            Optional<WorkerTaskResult> endedTask = this.childWorkerTaskTypeToWorkerTask(state, parentTaskRun);
            if (endedTask.isPresent()) {
                WorkerTaskResult workerTaskResult = endedTask.get();
                if (workerTaskResult.getTaskRun().getState().isTerminated()) {
                    try {
                        Output outputs = flowableParent.outputs(runContext);
                        Map outputMap = MapUtils.merge((Map)workerTaskResult.getTaskRun().getOutputs(), (Map)(outputs == null ? null : outputs.toMap()));
                        Variables variables = this.variablesService.of(StorageContext.forTask((TaskRun)workerTaskResult.getTaskRun()), outputMap);
                        return Optional.of(new WorkerTaskResult(workerTaskResult.getTaskRun().withOutputs(variables)));
                    }
                    catch (Exception e) {
                        runContext.logger().error("Unable to resolve outputs from the Flowable task: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                return endedTask;
            }
            if (execution.getState().getCurrent() == State.Type.KILLING) {
                if (parentTaskRun.getState().getCurrent() != State.Type.KILLING) {
                    return this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLING), parentTaskRun);
                }
                List currentTasks = execution.findTaskDependingFlowState(flowableParent.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks((List)flowableParent.getErrors(), (TaskRun)parentTaskRun), FlowableUtils.resolveTasks((List)flowableParent.getFinally(), (TaskRun)parentTaskRun));
                List taskRunByTasks = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
                if (taskRunByTasks.stream().filter(t -> t.getState().isTerminated()).count() == (long)taskRunByTasks.size()) {
                    return this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLED), parentTaskRun);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<WorkerTaskResult> childWorkerTaskTypeToWorkerTask(Optional<State.Type> findState, TaskRun taskRun) {
        return findState.map(Rethrow.throwFunction(type -> new WorkerTaskResult(taskRun.withState(type))));
    }

    private List<TaskRun> childNextsTaskRun(Executor executor, TaskRun parentTaskRun) throws InternalException {
        Task parent = executor.getFlow().findTaskByTaskId(parentTaskRun.getTaskId());
        if (parent instanceof FlowableTask) {
            FlowableTask flowableParent = (FlowableTask)parent;
            this.metricRegistry.counter("executor.flowable.execution.count", "The total number of flowable tasks executed by the Executor", this.metricRegistry.tags(parent)).increment();
            try {
                List nexts = flowableParent.resolveNexts(this.runContextFactory.of((FlowInterface)executor.getFlow(), parent, executor.getExecution(), parentTaskRun), executor.getExecution(), parentTaskRun);
                if (!nexts.isEmpty()) {
                    return this.saveFlowableOutput(nexts, executor);
                }
            }
            catch (Exception e) {
                log.warn("Unable to resolve the next tasks to run", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<TaskRun> saveFlowableOutput(List<NextTaskRun> nextTaskRuns, Executor executor) {
        return nextTaskRuns.stream().map(Rethrow.throwFunction(t -> {
            TaskRun taskRun = t.getTaskRun();
            if (!(t.getTask() instanceof FlowableTask)) {
                return taskRun;
            }
            FlowableTask flowableTask = (FlowableTask)t.getTask();
            RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), t.getTask(), executor.getExecution(), t.getTaskRun());
            try {
                Output outputs = flowableTask.outputs(runContext);
                Variables variables = this.variablesService.of(StorageContext.forTask((TaskRun)taskRun), outputs);
                taskRun = taskRun.withOutputs(variables);
            }
            catch (Exception e) {
                runContext.logger().warn("Unable to save output on taskRun '{}'", (Object)taskRun, (Object)e);
            }
            return taskRun;
        })).toList();
    }

    private Executor onEnd(Executor executor) {
        FlowWithSource flow = executor.getFlow();
        Execution newExecution = executor.getExecution().withState(executor.getExecution().guessFinalState((Flow)flow));
        if (flow.getOutputs() != null) {
            RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executor.getExecution());
            try {
                Map outputs = FlowInputOutput.renderFlowOutputs((List)flow.getOutputs(), (RunContext)runContext);
                outputs = this.flowInputOutput.typedOutputs((FlowInterface)flow, executor.getExecution(), outputs);
                newExecution = newExecution.withOutputs(outputs);
            }
            catch (Exception e) {
                this.logService.logExecution(executor.getExecution(), Level.ERROR, "Failed to render output values", new Object[]{e});
                runContext.logger().error("Failed to render output values: {}", (Object)e.getMessage(), (Object)e);
                newExecution = newExecution.withState(State.Type.FAILED);
            }
        }
        this.logService.logExecution(newExecution, Level.INFO, "Flow completed with state {} in {}", new Object[]{newExecution.getState().getCurrent(), newExecution.getState().humanDuration()});
        if (log.isTraceEnabled()) {
            log.trace(newExecution.toString(true));
        }
        this.metricRegistry.counter("executor.execution.end.count", "The total number of executions ended by the Executor", this.metricRegistry.tags(newExecution)).increment();
        this.metricRegistry.timer("executor.execution.duration", "Execution duration inside the Executor", this.metricRegistry.tags(newExecution)).record(newExecution.getState().getDuration());
        return executor.withExecution(newExecution, "onEnd");
    }

    private Executor handleNext(Executor executor) {
        List nextTaskRuns = FlowableUtils.resolveSequentialNexts((Execution)executor.getExecution(), (List)ResolvedTask.of((List)executor.getFlow().getTasks()), (List)ResolvedTask.of((List)executor.getFlow().getErrors()), (List)ResolvedTask.of((List)executor.getFlow().getFinally()));
        if (nextTaskRuns.isEmpty()) {
            return executor;
        }
        return executor.withTaskRun(this.saveFlowableOutput(nextTaskRuns, executor), "handleNext");
    }

    private Executor handleChildNext(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null) {
            return executor;
        }
        List<TaskRun> running = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().isRunning()).toList();
        ArrayList<TaskRun> result = new ArrayList<TaskRun>();
        for (TaskRun taskRun2 : running) {
            result.addAll(this.childNextsTaskRun(executor, taskRun2));
        }
        if (result.isEmpty()) {
            return executor;
        }
        return executor.withTaskRun(result, "handleChildNext");
    }

    /*
     * Unable to fully structure code
     */
    private Executor handleChildWorkerTaskResult(Executor executor) throws Exception {
        if (executor.getExecution().getTaskRunList() == null) {
            return executor;
        }
        list = new ArrayList<WorkerTaskResult>();
        executionDelays = new ArrayList<ExecutionDelay>();
        onPauses = new ArrayList<WorkerTask>();
        for (TaskRun taskRun : executor.getExecution().getTaskRunList()) {
            block22: {
                block21: {
                    if (taskRun.getState().isRunning()) {
                        workerTaskResult = this.childWorkerTaskResult((Flow)executor.getFlow(), executor.getExecution(), taskRun);
                        workerTaskResult.ifPresent((Consumer<WorkerTaskResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lio/kestra/core/runners/WorkerTaskResult;)V)(list));
                    }
                    task = executor.getFlow().findTaskByTaskIdOrNull(taskRun.getTaskId());
                    if (executor.getExecution().getState().isRetrying() || !taskRun.getState().isFailed() || !(task instanceof RunnableTask) && !(task instanceof Subflow)) break block21;
                    nextRetryDate = null;
                    behavior = null;
                    if (task.getRetry() != null) {
                        retry = task.getRetry();
                        behavior = retry.getBehavior();
                        nextRetryDate = behavior.equals((Object)AbstractRetry.Behavior.CREATE_NEW_EXECUTION) != false ? taskRun.nextRetryDate(retry, executor.getExecution()) : taskRun.nextRetryDate(retry);
                    } else {
                        retry = this.searchForParentRetry(taskRun, executor);
                        if (retry != null) {
                            behavior = retry.getBehavior();
                            nextRetryDate = behavior.equals((Object)AbstractRetry.Behavior.CREATE_NEW_EXECUTION) != false ? taskRun.nextRetryDate(retry, executor.getExecution()) : taskRun.nextRetryDate(retry);
                        } else if (executor.getFlow().getRetry() != null) {
                            retry = executor.getFlow().getRetry();
                            behavior = retry.getBehavior();
                            v0 = nextRetryDate = behavior.equals((Object)AbstractRetry.Behavior.CREATE_NEW_EXECUTION) != false ? this.executionService.nextRetryDate(retry, executor.getExecution()) : taskRun.nextRetryDate(retry);
                        }
                    }
                    if (nextRetryDate != null) {
                        executionDelayBuilder = ExecutionDelay.builder().taskRunId(taskRun.getId()).executionId(executor.getExecution().getId()).date(nextRetryDate).state(State.Type.RUNNING).delayType(behavior.equals((Object)AbstractRetry.Behavior.CREATE_NEW_EXECUTION) != false ? ExecutionDelay.DelayType.RESTART_FAILED_FLOW : ExecutionDelay.DelayType.RESTART_FAILED_TASK);
                        executionDelays.add(executionDelayBuilder.build());
                        executor.withExecution(behavior.equals((Object)AbstractRetry.Behavior.CREATE_NEW_EXECUTION) != false ? this.executionService.markWithTaskRunAs(executor.getExecution(), taskRun.getId(), State.Type.RETRIED, Boolean.valueOf(true)) : this.executionService.markWithTaskRunAs(executor.getExecution(), taskRun.getId(), State.Type.RETRYING, Boolean.valueOf(false)), "handleRetryTask");
                        if (taskRun.getParentTaskRunId() != null) {
                            list = list.stream().filter((Predicate<WorkerTaskResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleChildWorkerTaskResult$4(io.kestra.core.models.executions.TaskRun io.kestra.core.runners.WorkerTaskResult ), (Lio/kestra/core/runners/WorkerTaskResult;)Z)((TaskRun)taskRun)).collect(Collectors.toCollection((Supplier<ArrayList>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/ArrayList;)()));
                        }
                    }
                    break block22;
                }
                if (!(task instanceof LoopUntil)) ** GOTO lbl-1000
                waitFor = (LoopUntil)task;
                if (taskRun.getState().isRunning()) {
                    if (waitFor.childTaskRunExecuted(executor.getExecution(), taskRun)) {
                        newOutput = waitFor.outputs(taskRun);
                        variables = this.variablesService.of(StorageContext.forTask((TaskRun)taskRun), (Output)newOutput);
                        updatedTaskRun = taskRun.withOutputs(variables);
                        runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), task, executor.getExecution().withTaskRun(updatedTaskRun), updatedTaskRun);
                        next = ((FlowableTask)task).resolveNexts(runContext, executor.getExecution(), updatedTaskRun);
                        nextDate = waitFor.nextExecutionDate(runContext, executor.getExecution(), updatedTaskRun);
                        if (next.isEmpty()) {
                            return executor;
                        }
                        if (nextDate != null) {
                            executionDelays.add(ExecutionDelay.builder().taskRunId(taskRun.getId()).executionId(executor.getExecution().getId()).date(nextDate).state(State.Type.RUNNING).delayType(ExecutionDelay.DelayType.CONTINUE_FLOWABLE).build());
                            execution = this.executionService.pauseFlowable(executor.getExecution(), updatedTaskRun);
                            executor.withExecution(execution, "pauseLoop");
                        } else {
                            executor.withExecution(executor.getExecution().withTaskRun(updatedTaskRun), "handleWaitFor");
                        }
                    }
                } else if (task instanceof Pause && (pause = (Pause)task).getOnPause() != null) {
                    runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executor.getExecution());
                    onPauses.add(WorkerTask.builder().runContext(runContext).taskRun(TaskRun.of((Execution)executor.getExecution(), (ResolvedTask)ResolvedTask.of((Task)pause.getOnPause()))).task(pause.getOnPause()).executionKind(executor.getExecution().getKind()).build());
                }
            }
            if (taskRun.getState().isRetrying() && taskRun.getParentTaskRunId() != null) {
                list = list.stream().filter((Predicate<WorkerTaskResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleChildWorkerTaskResult$5(io.kestra.core.models.executions.TaskRun io.kestra.core.runners.WorkerTaskResult ), (Lio/kestra/core/runners/WorkerTaskResult;)Z)((TaskRun)taskRun)).collect(Collectors.toCollection((Supplier<ArrayList>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/ArrayList;)()));
            }
            if (!(task instanceof FlowableTask) || !taskRun.getState().isTerminated() || (updated = executor.getExecution().findChildren(taskRun).stream().filter((Predicate<TaskRun>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleChildWorkerTaskResult$6(io.kestra.core.models.executions.TaskRun ), (Lio/kestra/core/models/executions/TaskRun;)Z)()).map(Rethrow.throwFunction((Rethrow.FunctionChecked)(Rethrow.FunctionChecked)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleChildWorkerTaskResult$7(io.kestra.core.models.executions.TaskRun io.kestra.core.models.executions.TaskRun ), (Lio/kestra/core/models/executions/TaskRun;)Lio/kestra/core/models/executions/TaskRun;)((TaskRun)taskRun))).toList()).isEmpty()) continue;
            execution = executor.getExecution();
            for (TaskRun child : updated) {
                execution = execution.withTaskRun(child);
            }
            executor = executor.withExecution(execution, "handledTerminatedFlowableTasks");
        }
        this.metricRegistry.counter("executor.execution.delay.created.count", "The total number of execution delays created by the Executor", this.metricRegistry.tags(executor.getExecution())).increment((double)executionDelays.size());
        executor.withWorkerTaskDelays(executionDelays, "handleChildWorkerTaskDelay");
        if (list.isEmpty()) {
            return executor;
        }
        if (!onPauses.isEmpty()) {
            taskRuns = onPauses.stream().map((Function<WorkerTask, TaskRun>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getTaskRun(), (Lio/kestra/core/runners/WorkerTask;)Lio/kestra/core/models/executions/TaskRun;)()).toList();
            executor.withTaskRun(taskRuns, "handlePauses");
            executor.withWorkerTasks(onPauses, "handlePauses");
        }
        executor = this.handlePausedDelay(executor, list);
        this.addWorkerTaskResults(executor, list);
        return executor;
    }

    private AbstractRetry searchForParentRetry(TaskRun taskRun, Executor executor) {
        if (taskRun.getParentTaskRunId() != null) {
            Task parentTask;
            String taskId = taskRun.getTaskId();
            do {
                if ((parentTask = executor.getFlow().findParentTasksByTaskId(taskId)) == null) continue;
                taskId = parentTask.getId();
            } while (parentTask != null && parentTask.getRetry() == null);
            if (parentTask != null) {
                return parentTask.getRetry();
            }
        }
        return null;
    }

    private Executor handlePausedDelay(Executor executor, List<WorkerTaskResult> workerTaskResults) throws InternalException {
        if (workerTaskResults.stream().noneMatch(workerTaskResult -> workerTaskResult.getTaskRun().getState().getCurrent() == State.Type.PAUSED)) {
            return executor;
        }
        List<ExecutionDelay> list = workerTaskResults.stream().filter(workerTaskResult -> workerTaskResult.getTaskRun().getState().getCurrent() == State.Type.PAUSED).map(Rethrow.throwFunction(workerTaskResult -> {
            Pause pauseTask;
            Task task = executor.getFlow().findTaskByTaskId(workerTaskResult.getTaskRun().getTaskId());
            if (task instanceof Pause && ((pauseTask = (Pause)task).getPauseDuration() != null || pauseTask.getTimeout() != null)) {
                RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executor.getExecution());
                Duration duration = runContext.render(pauseTask.getPauseDuration()).as(Duration.class).orElse(null);
                Duration timeout = runContext.render(pauseTask.getTimeout()).as(Duration.class).orElse(null);
                Pause.Behavior behavior = runContext.render(pauseTask.getBehavior()).as(Pause.Behavior.class).orElse(Pause.Behavior.RESUME);
                if (duration != null || timeout != null) {
                    return ExecutionDelay.builder().taskRunId(workerTaskResult.getTaskRun().getId()).executionId(executor.getExecution().getId()).date(workerTaskResult.getTaskRun().getState().maxDate().plus(duration != null ? duration : timeout)).state(duration != null ? behavior.mapToState() : State.Type.fail((Task)pauseTask)).delayType(ExecutionDelay.DelayType.RESUME_FLOW).build();
                }
            }
            return null;
        })).filter(Objects::nonNull).toList();
        if (executor.getExecution().getState().getCurrent() != State.Type.PAUSED) {
            return executor.withExecution(executor.getExecution().withState(State.Type.PAUSED), "handlePausedDelay").withWorkerTaskDelays(list, "handlePausedDelay");
        }
        return executor.withWorkerTaskDelays(list, "handlePausedDelay");
    }

    private Executor handleCreatedKilling(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null || executor.getExecution().getState().getCurrent() != State.Type.KILLING) {
            return executor;
        }
        List<WorkerTaskResult> workerTaskResults = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent().isCreated()).map(t -> this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLED), (TaskRun)t)).filter(Optional::isPresent).map(Optional::get).toList();
        this.addWorkerTaskResults(executor, workerTaskResults);
        return executor;
    }

    private Executor handleAfterExecution(Executor executor) {
        if (!executor.getExecution().getState().isTerminated()) {
            return executor;
        }
        List listenerResolvedTasks = this.conditionService.findValidListeners((Flow)executor.getFlow(), executor.getExecution());
        List listenerNexts = FlowableUtils.resolveSequentialNexts((Execution)executor.getExecution(), (List)listenerResolvedTasks).stream().map(Rethrow.throwFunction(NextTaskRun::getTaskRun)).toList();
        if (!listenerNexts.isEmpty()) {
            return executor.withTaskRun(listenerNexts, "handleListeners");
        }
        if (!listenerResolvedTasks.isEmpty() && !executor.getExecution().isTerminated(listenerResolvedTasks)) {
            return executor;
        }
        List afterExecutionResolvedTasks = this.executionService.resolveAfterExecutionTasks((Flow)executor.getFlow());
        List<TaskRun> afterExecutionNexts = FlowableUtils.resolveSequentialNexts((Execution)executor.getExecution(), (List)afterExecutionResolvedTasks).stream().map(Rethrow.throwFunction(NextTaskRun::getTaskRun)).map(taskRun -> taskRun.withForceExecution(Boolean.valueOf(true))).toList();
        if (!afterExecutionNexts.isEmpty()) {
            return executor.withTaskRun(afterExecutionNexts, "handleAfterExecution ");
        }
        return executor;
    }

    private Executor handleEnd(Executor executor) {
        if (executor.getExecution().getState().isTerminated() || executor.getExecution().getState().isPaused() || executor.getExecution().getState().isRetrying()) {
            return executor;
        }
        List currentTasks = executor.getExecution().findTaskDependingFlowState(ResolvedTask.of((List)executor.getFlow().getTasks()), ResolvedTask.of((List)executor.getFlow().getErrors()), ResolvedTask.of((List)executor.getFlow().getFinally()));
        if (!executor.getExecution().isTerminated(currentTasks)) {
            return executor;
        }
        return this.onEnd(executor);
    }

    private Executor handleRestart(Executor executor) {
        if (executor.getExecution().getState().getCurrent() != State.Type.RESTARTED) {
            return executor;
        }
        this.metricRegistry.counter("executor.execution.started.count", "The total number of executions started by the Executor", this.metricRegistry.tags(executor.getExecution())).increment();
        this.logService.logExecution(executor.getExecution(), Level.INFO, "Flow restarted", new Object[0]);
        return executor.withExecution(executor.getExecution().withState(State.Type.RUNNING), "handleRestart");
    }

    private Executor handleKilling(Executor executor) {
        if (executor.getExecution().getState().getCurrent() != State.Type.KILLING) {
            return executor;
        }
        Execution newExecution = executor.getExecution().withState(State.Type.KILLED);
        return executor.withExecution(newExecution, "handleKilling");
    }

    private Executor handleWorkerTask(Executor executor) throws InternalException {
        List<WorkerTask> processingTasks;
        List<WorkerTask> endedTasks;
        if (executor.getExecution().getTaskRunList() == null || executor.getExecution().getState().getCurrent() == State.Type.KILLING) {
            return executor;
        }
        Optional<TextMapPropagator> textMapPropagator = this.openTelemetry.map(OpenTelemetry::getPropagators).map(ContextPropagators::getTextMapPropagator);
        Map<Boolean, List<WorkerTask>> workerTasks = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent().isCreated() && executor.getExecution().getFixtureForTaskRun(taskRun).isEmpty()).map(Rethrow.throwFunction(taskRun -> {
            Task task = executor.getFlow().findTaskByTaskId(taskRun.getTaskId());
            RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), task, executor.getExecution(), taskRun);
            textMapPropagator.ifPresent(propagator -> propagator.inject(Context.current(), (Object)runContext, (TextMapSetter)RunContextTextMapSetter.INSTANCE));
            WorkerTask workerTask = WorkerTask.builder().runContext(runContext).taskRun(taskRun).task(task).executionKind(executor.getExecution().getKind()).build();
            Optional workerGroup = this.workerGroupService.resolveGroupFromJob((FlowInterface)executor.getFlow(), (WorkerJob)workerTask);
            if (workerGroup.isPresent()) {
                String tenantId = executor.getFlow().getTenantId();
                String workerGroupKey = runContext.render(((WorkerGroup)workerGroup.get()).getKey());
                if (this.workerGroupExecutorInterface.isWorkerGroupExistForKey(workerGroupKey, tenantId)) {
                    if (this.workerGroupExecutorInterface.isWorkerGroupAvailableForKey(workerGroupKey)) {
                        return workerTask;
                    }
                    WorkerGroup.Fallback fallback = workerGroup.map(wg -> wg.getFallback()).orElse(WorkerGroup.Fallback.WAIT);
                    return switch (fallback) {
                        default -> throw new MatchException(null, null);
                        case WorkerGroup.Fallback.FAIL -> {
                            runContext.logger().error("No workers are available for worker group '{}', failing the task.", (Object)workerGroupKey);
                            yield workerTask.withTaskRun(workerTask.getTaskRun().fail());
                        }
                        case WorkerGroup.Fallback.CANCEL -> {
                            runContext.logger().info("No workers are available for worker group '{}', canceling the task.", (Object)workerGroupKey);
                            yield workerTask.withTaskRun(workerTask.getTaskRun().withState(State.Type.CANCELLED));
                        }
                        case WorkerGroup.Fallback.WAIT -> {
                            runContext.logger().info("No workers are available for worker group '{}', waiting for one to be available.", (Object)workerGroupKey);
                            yield workerTask;
                        }
                    };
                }
                runContext.logger().error("Cannot run task. No worker group exist for key '{}'.", (Object)workerGroupKey);
                return workerTask.withTaskRun(workerTask.getTaskRun().fail());
            }
            return workerTask;
        })).collect(Collectors.groupingBy(workerTask -> workerTask.getTaskRun().getState().isFailed() || workerTask.getTaskRun().getState().getCurrent() == State.Type.CANCELLED));
        boolean hasMockedWorkerTask = false;
        if (executor.getExecution().getFixtures() != null) {
            record FixtureAndTaskRun(TaskFixture fixture, TaskRun taskRun) {
            }
            RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executor.getExecution());
            List<WorkerTaskResult> workerTaskResults = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent().isCreated()).flatMap(taskRun -> executor.getExecution().getFixtureForTaskRun(taskRun).stream().map(fixture -> new FixtureAndTaskRun((TaskFixture)fixture, (TaskRun)taskRun))).map(Rethrow.throwFunction(fixtureAndTaskRun -> WorkerTaskResult.builder().taskRun(fixtureAndTaskRun.taskRun().withState(Optional.ofNullable(fixtureAndTaskRun.fixture().getState()).orElse(State.Type.SUCCESS)).withOutputs(this.variablesService.of(StorageContext.forTask((TaskRun)fixtureAndTaskRun.taskRun), fixtureAndTaskRun.fixture().getOutputs() == null ? null : runContext.render(fixtureAndTaskRun.fixture().getOutputs())))).build())).toList();
            hasMockedWorkerTask = !workerTaskResults.isEmpty();
            this.addWorkerTaskResults(executor, workerTaskResults);
        }
        if (workerTasks.isEmpty() || hasMockedWorkerTask) {
            return executor;
        }
        Executor executorToReturn = executor;
        if (!ListUtils.isEmpty((List)executor.getExecution().getBreakpoints())) {
            List breakpoints = executor.getExecution().getBreakpoints();
            if (executor.getExecution().getTaskRunList().stream().anyMatch(taskRun -> this.shouldSuspend((TaskRun)taskRun, breakpoints))) {
                List<TaskRun> newTaskRuns = executor.getExecution().getTaskRunList().stream().map(taskRun -> {
                    if (this.shouldSuspend((TaskRun)taskRun, breakpoints)) {
                        return taskRun.withState(State.Type.BREAKPOINT);
                    }
                    return taskRun;
                }).toList();
                Execution newExecution = executor.getExecution().withTaskRunList(newTaskRuns).withState(State.Type.BREAKPOINT);
                executorToReturn = executorToReturn.withExecution(newExecution, "handleBreakpoint");
                this.logService.logExecution(newExecution, Level.INFO, "Flow is suspended at a breakpoint.", new Object[0]);
            }
        }
        if ((endedTasks = workerTasks.get(true)) != null && !endedTasks.isEmpty()) {
            List<WorkerTaskResult> failed = endedTasks.stream().map(workerTask -> WorkerTaskResult.builder().taskRun(workerTask.getTaskRun()).build()).toList();
            this.addWorkerTaskResults(executor, failed);
        }
        if ((processingTasks = workerTasks.get(false)) != null && !processingTasks.isEmpty() && !executor.getExecution().getState().isBreakpoint()) {
            executorToReturn = executorToReturn.withWorkerTasks(processingTasks, "handleWorkerTask");
            this.metricRegistry.counter("executor.taskrun.created.count", "The total number of tasks created by the Executor", this.metricRegistry.tags(executor.getExecution())).increment((double)processingTasks.size());
        }
        return executorToReturn;
    }

    private boolean shouldSuspend(TaskRun taskRun, List<Breakpoint> breakpoints) {
        return taskRun.getState().getCurrent().isCreated() && breakpoints.stream().anyMatch(breakpoint -> taskRun.getTaskId().equals(breakpoint.getId()) && (breakpoint.getValue() == null || Objects.equals(taskRun.getValue(), breakpoint.getValue())));
    }

    private Executor handleExecutableTask(Executor executor) {
        ArrayList executions = new ArrayList();
        ArrayList subflowExecutionResults = new ArrayList();
        boolean haveFlows = executor.getWorkerTasks().removeIf(workerTask -> {
            if (!(workerTask.getTask() instanceof ExecutableTask)) {
                return false;
            }
            Task executableTask = (Task)((ExecutableTask)workerTask.getTask());
            try {
                TaskRun executableTaskRun = executor.getExecution().findTaskRunByTaskRunId(workerTask.getTaskRun().getId());
                executor.withExecution(executor.getExecution().withTaskRun(executableTaskRun.withState(State.Type.RUNNING)), "handleExecutableTaskRunning");
                if (!TruthUtils.isTruthy((String)workerTask.getRunContext().render(workerTask.getTask().getRunIf()))) {
                    executor.withExecution(executor.getExecution().withTaskRun(executableTaskRun.withState(State.Type.SKIPPED)), "handleExecutableTaskSkipped");
                    return false;
                }
                RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executableTask, executor.getExecution(), executableTaskRun);
                List subflowExecutions = ((ExecutableTask)executableTask).createSubflowExecutions(runContext, this.flowExecutorInterface(), (Flow)executor.getFlow(), executor.getExecution(), executableTaskRun);
                if (subflowExecutions.isEmpty()) {
                    executor.withExecution(executor.getExecution().withTaskRun(executableTaskRun.withState(State.Type.SUCCESS)), "handleExecutableTaskRunning.noExecution");
                } else {
                    executions.addAll(subflowExecutions);
                    Optional flow = this.flowExecutorInterface.findByExecution(((SubflowExecution)subflowExecutions.getFirst()).getExecution());
                    if (flow.isPresent()) {
                        for (SubflowExecution subflowExecution : subflowExecutions) {
                            Optional subflowExecutionResult = ((ExecutableTask)executableTask).createSubflowExecutionResult(runContext, ((ExecutableTask)executableTask).waitForExecution() ? subflowExecution.getParentTaskRun() : subflowExecution.getParentTaskRun().withState(State.Type.SUCCESS), (FlowInterface)flow.get(), subflowExecution.getExecution());
                            subflowExecutionResult.ifPresent(subflowExecutionResults::add);
                        }
                    } else {
                        log.error("Unable to find flow for execution {}", (Object)((SubflowExecution)subflowExecutions.getFirst()).getExecution().getId());
                    }
                }
            }
            catch (Exception e) {
                try {
                    executor.withExecution(executor.getExecution().withTaskRun(workerTask.getTaskRun().fail()), "handleExecutableTask").withException(e, "handleExecutableTask");
                }
                catch (InternalException ex) {
                    log.error("Unable to fail the executable task.", (Throwable)ex);
                }
            }
            return true;
        });
        if (!haveFlows) {
            return executor;
        }
        Executor resultExecutor = executor.withSubflowExecutions(executions, "handleExecutableTask");
        if (!subflowExecutionResults.isEmpty()) {
            resultExecutor = executor.withSubflowExecutionResults(subflowExecutionResults, "handleExecutableTaskWorkerTaskResults");
        }
        return resultExecutor;
    }

    private Executor handleExecutionUpdatingTask(Executor executor) throws InternalException {
        ArrayList<WorkerTaskResult> workerTaskResults = new ArrayList<WorkerTaskResult>();
        executor.getWorkerTasks().removeIf(workerTask -> {
            if (!(workerTask.getTask() instanceof ExecutionUpdatableTask)) {
                return false;
            }
            ExecutionUpdatableTask executionUpdatingTask = (ExecutionUpdatableTask)workerTask.getTask();
            try {
                if (!TruthUtils.isTruthy((String)workerTask.getRunContext().render(workerTask.getTask().getRunIf()))) {
                    executor.withExecution(executor.getExecution().withTaskRun(workerTask.getTaskRun().withState(State.Type.SKIPPED)), "handleExecutionUpdatingTaskSkipped");
                    return false;
                }
                executor.withExecution(executionUpdatingTask.update(executor.getExecution(), workerTask.getRunContext()).withTaskRun(workerTask.getTaskRun().withState(State.Type.RUNNING)), "handleExecutionUpdatingTask.updateExecution");
                State.Type taskState = executionUpdatingTask.resolveState(workerTask.getRunContext(), executor.getExecution()).orElse(State.Type.SUCCESS);
                workerTaskResults.add(WorkerTaskResult.builder().taskRun(workerTask.getTaskRun().withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(taskState)).build())).withState(taskState)).build());
            }
            catch (Exception e) {
                workerTaskResults.add(WorkerTaskResult.builder().taskRun(workerTask.getTaskRun().fail()).build());
                executor.withException(e, "handleExecutionUpdatingTask");
            }
            return true;
        });
        this.addWorkerTaskResults(executor, workerTaskResults);
        return executor;
    }

    public void addWorkerTaskResults(Executor executor, List<WorkerTaskResult> workerTaskResults) throws InternalException {
        for (WorkerTaskResult workerTaskResult : workerTaskResults) {
            this.addWorkerTaskResult(executor, () -> executor.getFlow(), workerTaskResult);
        }
    }

    public void addWorkerTaskResult(Executor executor, Supplier<Flow> flow, WorkerTaskResult workerTaskResult) throws InternalException {
        Execution newExecution = this.addDynamicTaskRun(executor.getExecution(), flow, workerTaskResult);
        if (newExecution != null) {
            executor.withExecution(newExecution, "addDynamicTaskRun");
        }
        TaskRun taskRun = workerTaskResult.getTaskRun();
        newExecution = executor.getExecution().withTaskRun(taskRun);
        if (taskRun.getState().getCurrent() == State.Type.KILLED && taskRun.getParentTaskRunId() != null) {
            newExecution = this.executionService.killParentTaskruns(taskRun, newExecution);
        }
        executor.withExecution(newExecution, "addWorkerTaskResult");
        if (taskRun.getState().isTerminated()) {
            log.trace("TaskRun terminated: {}", (Object)taskRun);
            this.workerJobRunningStateStore.deleteByKey(taskRun.getId());
            this.metricRegistry.counter("executor.taskrun.ended.count", "The total number of tasks ended by the Executor", this.metricRegistry.tags(workerTaskResult, new String[0])).increment();
            this.metricRegistry.timer("executor.taskrun.ended.duration", "Task duration inside the Executor", this.metricRegistry.tags(workerTaskResult, new String[0])).record(taskRun.getState().getDuration());
        }
    }

    private Execution addDynamicTaskRun(Execution execution, Supplier<Flow> flow, WorkerTaskResult workerTaskResult) throws InternalException {
        ArrayList<TaskRun> taskRuns;
        block4: {
            taskRuns = new ArrayList<TaskRun>(ListUtils.emptyOnNull((List)execution.getTaskRunList()));
            if (!ListUtils.isEmpty((List)workerTaskResult.getDynamicTaskRuns())) {
                taskRuns.addAll(workerTaskResult.getDynamicTaskRuns());
            }
            if (workerTaskResult.getTaskRun().getParentTaskRunId() != null) {
                try {
                    execution.findTaskRunByTaskRunId(workerTaskResult.getTaskRun().getId());
                }
                catch (InternalException e) {
                    TaskRun parentTaskRun = execution.findTaskRunByTaskRunId(workerTaskResult.getTaskRun().getParentTaskRunId());
                    Task parentTask = flow.get().findTaskByTaskId(parentTaskRun.getTaskId());
                    if (!(parentTask instanceof WorkingDirectory)) break block4;
                    taskRuns.add(workerTaskResult.getTaskRun());
                }
            }
        }
        return taskRuns.size() > ListUtils.emptyOnNull((List)execution.getTaskRunList()).size() ? execution.withTaskRunList(taskRuns) : null;
    }

    public boolean canBePurged(Executor executor) {
        return executor.getExecution().isDeleted() || executor.getFlow() != null && this.executionService.isTerminated((Flow)executor.getFlow(), executor.getExecution()) && executor.getExecution().getState().getCurrent() != State.Type.PAUSED && executor.getExecution().getState().getCurrent() != State.Type.KILLED;
    }

    public void log(Logger log, Boolean in, WorkerJob value) {
        if (log.isDebugEnabled()) {
            if (value instanceof WorkerTask) {
                WorkerTask workerTask = (WorkerTask)value;
                log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", workerTask.getClass().getSimpleName(), workerTask.getTaskRun().toStringState()});
            } else if (value instanceof WorkerTrigger) {
                WorkerTrigger workerTrigger = (WorkerTrigger)value;
                log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", workerTrigger.getClass().getSimpleName(), workerTrigger.getTriggerContext().uid()});
            }
        }
    }

    public void log(Logger log, Boolean in, WorkerTaskResult value) {
        if (log.isDebugEnabled()) {
            log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getTaskRun().toStringState()});
        }
    }

    public void log(Logger log, Boolean in, SubflowExecutionResult value) {
        if (log.isDebugEnabled()) {
            log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getParentTaskRun().toStringState()});
        }
    }

    public void log(Logger log, Boolean in, SubflowExecutionEnd value) {
        if (log.isDebugEnabled()) {
            log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.toStringState()});
        }
    }

    public void log(Logger log, Boolean in, Execution value) {
        if (log.isDebugEnabled()) {
            log.debug("{} {} [key='{}']\n{}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getId(), value.toStringState()});
        }
    }

    public void log(Logger log, Boolean in, Executor value) {
        if (log.isDebugEnabled()) {
            log.debug("{} {} [key='{}', from='{}', offset='{}', crc32='{}']\n{}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getExecution().getId(), value.getFrom(), value.getOffset(), value.getExecution().toCrc32State(), value.getExecution().toStringState()});
        }
    }

    public void log(Logger log, Boolean in, ExecutionKilledExecution value) {
        log.debug("{} {} [key='{}']\n{}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getExecutionId(), value});
    }

    public Executor handleExecutionChangedSLA(Executor executor) throws QueueException {
        if (executor.getFlow() == null || ListUtils.isEmpty((List)executor.getFlow().getSla()) || executor.getExecution().getState().isTerminated()) {
            return executor;
        }
        RunContext runContext = this.runContextFactory.of((FlowInterface)executor.getFlow(), executor.getExecution());
        List<Violation> violations = this.slaService.evaluateExecutionChangedSLA(runContext, (Flow)executor.getFlow(), executor.getExecution());
        if (!violations.isEmpty()) {
            this.metricRegistry.counter("executor.sla.violation.count", "The total number of expired SLA (i.e. executions with SLA of type MAX_DURATION that took longer than the SLA) evaluated by the Executor", this.metricRegistry.tags(executor.getExecution())).increment((double)violations.size());
            Violation violation = violations.getFirst();
            return this.processViolation(runContext, executor, violation);
        }
        return executor;
    }

    public Executor processViolation(RunContext runContext, Executor executor, Violation violation) throws QueueException {
        Execution newExecution;
        boolean hasChanged = false;
        switch (violation.behavior()) {
            default: {
                throw new MatchException(null, null);
            }
            case FAIL: {
                runContext.logger().error("Execution failed due to SLA '{}' violated: {}", (Object)violation.slaId(), (Object)violation.reason());
                hasChanged = true;
                Execution execution = this.markAs(executor.getExecution(), State.Type.FAILED);
                break;
            }
            case CANCEL: {
                hasChanged = true;
                Execution execution = this.markAs(executor.getExecution(), State.Type.CANCELLED);
                break;
            }
            case NONE: {
                Execution execution = newExecution = executor.getExecution();
            }
        }
        if (!ListUtils.isEmpty((List)violation.labels()) && !LabelService.containsAll((List)executor.getExecution().getLabels(), (List)violation.labels())) {
            ArrayList labels = new ArrayList(newExecution.getLabels());
            labels.addAll(violation.labels());
            hasChanged = true;
            newExecution = newExecution.withLabels(labels);
        }
        if (hasChanged) {
            return executor.withExecution(newExecution, "SLAViolation");
        }
        return executor;
    }

    private Execution markAs(Execution execution, State.Type state) throws QueueException {
        Execution newExecution = execution.findLastNotTerminated().map(taskRun -> {
            try {
                return execution.withTaskRun(taskRun.withState(state));
            }
            catch (InternalException e) {
                return execution;
            }
        }).orElse(execution).withState(state);
        this.killQueue.emit((Object)((ExecutionKilledExecution.ExecutionKilledExecutionBuilder)((ExecutionKilledExecution.ExecutionKilledExecutionBuilder)ExecutionKilledExecution.builder().state(ExecutionKilled.State.REQUESTED)).executionState(state).executionId(execution.getId()).isOnKillCascade(Boolean.valueOf(true)).tenantId(execution.getTenantId())).build());
        return newExecution;
    }

    private static /* synthetic */ TaskRun lambda$handleChildWorkerTaskResult$7(TaskRun taskRun, TaskRun child) throws RuntimeException {
        return child.withState(taskRun.getState().getCurrent());
    }

    private static /* synthetic */ boolean lambda$handleChildWorkerTaskResult$6(TaskRun child) {
        return !child.getState().isTerminated();
    }

    private static /* synthetic */ boolean lambda$handleChildWorkerTaskResult$5(TaskRun taskRun, WorkerTaskResult workerTaskResult) {
        return !workerTaskResult.getTaskRun().getId().equals(taskRun.getParentTaskRunId());
    }

    private static /* synthetic */ boolean lambda$handleChildWorkerTaskResult$4(TaskRun taskRun, WorkerTaskResult workerTaskResult) {
        return !workerTaskResult.getTaskRun().getId().equals(taskRun.getParentTaskRunId());
    }
}

