/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.h2;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilled;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.templates.Template;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueFactoryInterface;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.queues.WorkerJobQueueInterface;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.MultipleConditionEvent;
import io.kestra.core.runners.SubflowExecutionEnd;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerInstance;
import io.kestra.core.runners.WorkerJobRunning;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTriggerResult;
import io.kestra.runner.h2.H2Queue;
import io.kestra.runner.h2.H2QueueEnabled;
import io.kestra.runner.h2.H2WorkerJobQueue;
import io.kestra.runner.h2.H2WorkerTriggerResultQueue;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.commons.lang3.NotImplementedException;

@Factory
@H2QueueEnabled
public class H2QueueFactory
implements QueueFactoryInterface {
    @Inject
    ApplicationContext applicationContext;

    @Singleton
    @Named(value="executionQueue")
    @Bean(preDestroy="close")
    public QueueInterface<Execution> execution() {
        return new H2Queue<Execution>(Execution.class, this.applicationContext);
    }

    @Singleton
    @Named(value="executorQueue")
    @Bean(preDestroy="close")
    public QueueInterface<Executor> executor() {
        throw new NotImplementedException();
    }

    @Singleton
    @Named(value="workerJobQueue")
    @Bean(preDestroy="close")
    public WorkerJobQueueInterface workerJob() {
        return new H2WorkerJobQueue(this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskResultQueue")
    @Bean(preDestroy="close")
    public QueueInterface<WorkerTaskResult> workerTaskResult() {
        return new H2Queue<WorkerTaskResult>(WorkerTaskResult.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTriggerResultQueue")
    @Bean(preDestroy="close")
    public QueueInterface<WorkerTriggerResult> workerTriggerResult() {
        return new H2WorkerTriggerResultQueue(this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskLogQueue")
    @Bean(preDestroy="close")
    public QueueInterface<LogEntry> logEntry() {
        return new H2Queue<LogEntry>(LogEntry.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerTaskMetricQueue")
    @Bean(preDestroy="close")
    public QueueInterface<MetricEntry> metricEntry() {
        return new H2Queue<MetricEntry>(MetricEntry.class, this.applicationContext);
    }

    @Singleton
    @Named(value="flowQueue")
    @Bean(preDestroy="close")
    public QueueInterface<FlowInterface> flow() {
        return new H2Queue<FlowInterface>(FlowInterface.class, this.applicationContext);
    }

    @Singleton
    @Named(value="executionKilledQueue")
    @Bean(preDestroy="close")
    public QueueInterface<ExecutionKilled> kill() {
        return new H2Queue<ExecutionKilled>(ExecutionKilled.class, this.applicationContext);
    }

    @Singleton
    @Named(value="templateQueue")
    @Bean(preDestroy="close")
    public QueueInterface<Template> template() {
        return new H2Queue<Template>(Template.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerInstanceQueue")
    @Bean(preDestroy="close")
    public QueueInterface<WorkerInstance> workerInstance() {
        return new H2Queue<WorkerInstance>(WorkerInstance.class, this.applicationContext);
    }

    @Singleton
    @Named(value="workerJobRunningQueue")
    @Bean(preDestroy="close")
    public QueueInterface<WorkerJobRunning> workerJobRunning() {
        return new H2Queue<WorkerJobRunning>(WorkerJobRunning.class, this.applicationContext);
    }

    @Singleton
    @Named(value="triggerQueue")
    @Bean(preDestroy="close")
    public QueueInterface<Trigger> trigger() {
        return new H2Queue<Trigger>(Trigger.class, this.applicationContext);
    }

    @Singleton
    @Named(value="subflowExecutionResultQueue")
    @Bean(preDestroy="close")
    public QueueInterface<SubflowExecutionResult> subflowExecutionResult() {
        return new H2Queue<SubflowExecutionResult>(SubflowExecutionResult.class, this.applicationContext);
    }

    @Singleton
    @Named(value="subflowExecutionEndQueue")
    @Bean(preDestroy="close")
    public QueueInterface<SubflowExecutionEnd> subflowExecutionEnd() {
        return new H2Queue<SubflowExecutionEnd>(SubflowExecutionEnd.class, this.applicationContext);
    }

    @Singleton
    @Named(value="multipleConditionEventQueue")
    @Bean(preDestroy="close")
    public QueueInterface<MultipleConditionEvent> multipleConditionEvent() {
        return new H2Queue<MultipleConditionEvent>(MultipleConditionEvent.class, this.applicationContext);
    }
}

