/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.h2;

import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.utils.DateUtils;
import io.kestra.jdbc.repository.AbstractJdbcTriggerRepository;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.repository.h2.H2Repository;
import io.kestra.repository.h2.H2RepositoryEnabled;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Date;
import org.jooq.Field;
import org.jooq.impl.DSL;

@Singleton
@H2RepositoryEnabled
public class H2TriggerRepository
extends AbstractJdbcTriggerRepository {
    @Inject
    public H2TriggerRepository(@Named(value="triggers") H2Repository<Trigger> repository, JdbcFilterService filterService) {
        super(repository, filterService);
    }

    protected Field<Date> formatDateField(String dateField, DateUtils.GroupType groupType) {
        switch (groupType) {
            case MONTH: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM')"), Date.class);
            }
            case WEEK: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'YYYY-ww')"), Date.class);
            }
            case DAY: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd')"), Date.class);
            }
            case HOUR: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd HH:00:00')"), Date.class);
            }
            case MINUTE: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd HH:mm:00')"), Date.class);
            }
        }
        throw new IllegalArgumentException("Unsupported GroupType: " + String.valueOf(groupType));
    }
}

