/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.runner.h2;

import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcQueue;
import io.micronaut.context.ApplicationContext;
import java.time.LocalDateTime;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectLimitPercentStep;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class H2Queue<T>
extends JdbcQueue<T> {
    public H2Queue(Class<T> cls, ApplicationContext applicationContext) {
        super(cls, applicationContext);
    }

    protected Condition buildTypeCondition(String type) {
        return AbstractJdbcRepository.field((String)"type").eq((Object)type);
    }

    protected Result<Record> receiveFetch(DSLContext ctx, String consumerGroup, String queueType, boolean forUpdate) {
        SelectLimitPercentStep limitSelect;
        SelectConditionStep select = ctx.select((SelectField)AbstractJdbcRepository.field((String)"value"), (SelectField)AbstractJdbcRepository.field((String)"offset")).from((TableLike)this.table).where(AbstractJdbcRepository.field((String)"type").eq((Object)this.queueType())).and(DSL.or(List.of(AbstractJdbcRepository.field((String)"consumers").isNull(), DSL.condition((String)"NOT(ARRAY_CONTAINS(\"consumers\", ?))", (Object[])new Object[]{queueType}))));
        select = consumerGroup != null ? select.and(AbstractJdbcRepository.field((String)"consumer_group").eq((Object)consumerGroup)) : select.and(AbstractJdbcRepository.field((String)"consumer_group").isNull());
        SelectLimitPercentStep configuredSelect = limitSelect = select.orderBy((OrderField)AbstractJdbcRepository.field((String)"offset").asc()).limit((Number)this.configuration.getPollSize());
        if (forUpdate) {
            configuredSelect = limitSelect.forUpdate().skipLocked();
        }
        return (Result)configuredSelect.fetchMany().getFirst();
    }

    protected void updateGroupOffsets(DSLContext ctx, String consumerGroup, String queueType, List<Integer> offsets) {
        UpdateConditionStep update = ctx.update(DSL.table((String)this.table.getName())).set(AbstractJdbcRepository.field((String)"consumers"), (Object)DSL.field((String)"ARRAY_APPEND(COALESCE(\"consumers\", ARRAY[]), ?)", (Class)SQLDataType.VARCHAR((int)50).getArrayType(), (Object[])new Object[]{new String[]{queueType}})).set(AbstractJdbcRepository.field((String)"updated"), (Object)LocalDateTime.now()).where(AbstractJdbcRepository.field((String)"offset").in((Object[])offsets.toArray(Integer[]::new)));
        update = consumerGroup != null ? update.and(AbstractJdbcRepository.field((String)"consumer_group").eq((Object)consumerGroup)) : update.and(AbstractJdbcRepository.field((String)"consumer_group").isNull());
        update.execute();
    }
}

