/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.h2;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.Either;
import io.kestra.jdbc.AbstractJdbcRepository;
import io.kestra.jdbc.repository.AbstractJdbcExecutionRepository;
import io.kestra.jdbc.runner.AbstractJdbcExecutorStateStorage;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.repository.h2.H2ExecutionRepositoryService;
import io.kestra.repository.h2.H2Repository;
import io.kestra.repository.h2.H2RepositoryEnabled;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Date;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

@Singleton
@H2RepositoryEnabled
public class H2ExecutionRepository
extends AbstractJdbcExecutionRepository {
    @Inject
    public H2ExecutionRepository(@Named(value="executions") H2Repository<Execution> repository, ApplicationContext applicationContext, AbstractJdbcExecutorStateStorage executorStateStorage, JdbcFilterService filterService) {
        super(repository, applicationContext, executorStateStorage, filterService);
    }

    protected Condition findCondition(String query, Map<String, String> labels) {
        return H2ExecutionRepositoryService.findCondition((AbstractJdbcRepository<Execution>)this.jdbcRepository, query, labels);
    }

    protected Condition findLabelCondition(Either<Map<?, ?>, String> input, QueryFilter.Op operation) {
        return H2ExecutionRepositoryService.findLabelCondition(input, operation);
    }

    protected Field<Date> formatDateField(String dateField, DateUtils.GroupType groupType) {
        switch (groupType) {
            case MONTH: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM')"), Date.class);
            }
            case WEEK: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'YYYY-ww')"), Date.class);
            }
            case DAY: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd')"), Date.class);
            }
            case HOUR: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd HH:00:00')"), Date.class);
            }
            case MINUTE: {
                return DSL.field((String)("FORMATDATETIME(\"" + dateField + "\", 'yyyy-MM-dd HH:mm:00')"), Date.class);
            }
        }
        throw new IllegalArgumentException("Unsupported GroupType: " + String.valueOf(groupType));
    }
}

