/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.h2;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.utils.Either;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public abstract class H2ExecutionRepositoryService {
    public static Condition findCondition(AbstractJdbcRepository<Execution> jdbcRepository, String query, Map<String, String> labels) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (query != null) {
            conditions.add(jdbcRepository.fullTextCondition(List.of("fulltext"), query));
        }
        if (labels != null) {
            labels.forEach((key, value) -> {
                Field valueField = DSL.field((String)("JQ_STRING(\"value\", '.labels[]? | select(.key == \"" + key + "\") | .value')"), String.class);
                if (value == null) {
                    conditions.add(valueField.isNull());
                } else {
                    conditions.add(valueField.eq(value));
                }
            });
        }
        return conditions.isEmpty() ? DSL.trueCondition() : DSL.and(conditions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Condition findLabelCondition(Either<Map<?, ?>, String> input, QueryFilter.Op operation) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        ArrayList inConditions = new ArrayList();
        if (input.isRight()) {
            String query = (String)input.right().get();
            Field keyField = DSL.field((String)"JQ_STRING(\"value\", '.labels[]? | .key')", String.class);
            Field valueField = DSL.field((String)"JQ_STRING(\"value\", '.labels[]? | .value')", String.class);
            if (Objects.requireNonNull(operation) != QueryFilter.Op.CONTAINS) throw new UnsupportedOperationException("Unsupported operation for query: " + String.valueOf(operation));
            conditions.add(keyField.contains((Object)query).or(valueField.contains((Object)query)));
        } else {
            Map labels = (Map)input.left().get();
            labels.forEach((key, value) -> {
                Field valueField = DSL.field((String)("JQ_STRING(\"value\", '.labels[]? | select(.key == \"" + String.valueOf(key) + "\") | .value')"), String.class);
                switch (operation) {
                    case EQUALS: {
                        conditions.add(value == null ? valueField.isNull() : valueField.eq((Object)((String)value)));
                        break;
                    }
                    case NOT_EQUALS: 
                    case NOT_IN: {
                        conditions.add(value == null ? valueField.isNotNull() : valueField.isNull().or(valueField.ne((Object)((String)value))));
                        break;
                    }
                    case IN: {
                        inConditions.add(value == null ? valueField.isNull() : valueField.eq((Object)((String)value)));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported operation: " + String.valueOf(operation));
                    }
                }
            });
        }
        if (inConditions.isEmpty()) return conditions.isEmpty() ? DSL.trueCondition() : DSL.and(conditions);
        conditions.add(DSL.or(inConditions));
        return conditions.isEmpty() ? DSL.trueCondition() : DSL.and(conditions);
    }
}

