/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.h2;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public abstract class H2FlowRepositoryService {
    public static Condition findCondition(AbstractJdbcRepository<? extends FlowInterface> jdbcRepository, String query, Map<String, String> labels) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (query != null) {
            conditions.add(jdbcRepository.fullTextCondition(List.of("fulltext"), query));
        }
        if (labels != null) {
            labels.forEach((key, value) -> {
                Field valueField = DSL.field((String)("JQ_STRING(\"value\", '.labels[]? | select(.key == \"" + key + "\") | .value')"), String.class);
                if (value == null) {
                    conditions.add(valueField.isNull());
                } else {
                    conditions.add(valueField.eq(value));
                }
            });
        }
        return conditions.isEmpty() ? DSL.trueCondition() : DSL.and(conditions);
    }

    public static Condition findSourceCodeCondition(AbstractJdbcRepository<? extends FlowInterface> jdbcRepository, String query) {
        return jdbcRepository.fullTextCondition(List.of("source_code"), query);
    }

    public static Condition findCondition(Object labels, QueryFilter.Op operation) {
        ArrayList conditions = new ArrayList();
        if (labels instanceof Map) {
            Map labelValues = (Map)labels;
            labelValues.forEach((key, value) -> {
                Field valueField = DSL.field((String)("JQ_STRING(\"value\", '.labels[]? | select(.key == \"" + String.valueOf(key) + "\") | .value')"), String.class);
                Condition condition = switch (operation) {
                    case QueryFilter.Op.EQUALS -> {
                        if (value == null) {
                            yield valueField.isNull();
                        }
                        yield valueField.eq((Object)((String)value));
                    }
                    case QueryFilter.Op.NOT_EQUALS -> {
                        if (value == null) {
                            yield valueField.isNotNull();
                        }
                        yield valueField.ne((Object)((String)value));
                    }
                    default -> throw new UnsupportedOperationException("Unsupported operation: " + String.valueOf(operation));
                };
                conditions.add(condition);
            });
        }
        return conditions.isEmpty() ? DSL.trueCondition() : DSL.and(conditions);
    }
}

