/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.repository.h2;

import io.kestra.core.queues.QueueService;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.jdbc.JdbcTableConfig;
import io.kestra.jdbc.JooqDSLContextWrapper;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.repository.h2.H2RepositoryEnabled;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

@H2RepositoryEnabled
@EachBean(value=JdbcTableConfig.class)
public class H2Repository<T>
extends io.kestra.jdbc.AbstractJdbcRepository<T> {
    @Inject
    public H2Repository(@Parameter JdbcTableConfig jdbcTableConfig, QueueService queueService, JooqDSLContextWrapper dslContextWrapper) {
        super(jdbcTableConfig, queueService, dslContextWrapper);
    }

    public void persist(T entity, DSLContext context, @Nullable Map<Field<Object>, Object> fields) {
        Map finalFields = fields == null ? this.persistFields(entity) : fields;
        this.persistInternal(entity, context, finalFields);
    }

    private int persistInternal(T entity, DSLContext context, Map<Field<Object>, Object> fields) {
        int affectedRows = context.update(this.table).set(fields).where(AbstractJdbcRepository.field((String)"key").eq((Object)this.key(entity))).execute();
        if (affectedRows == 0) {
            return context.insertInto(this.table).set(AbstractJdbcRepository.field((String)"key"), (Object)this.key(entity)).set(fields).execute();
        }
        return affectedRows;
    }

    public int persistBatch(List<T> items) {
        return (Integer)this.dslContextWrapper.transactionResult(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            return items.stream().map(item -> this.persistInternal(item, dslContext, this.persistFields(item))).mapToInt(i -> i).sum();
        });
    }

    public Condition fullTextCondition(List<String> fields, String query) {
        if (query == null || query.equals("*")) {
            return DSL.trueCondition();
        }
        if (fields.size() > 1) {
            throw new IllegalStateException("Too many fields for h2 '" + String.valueOf(fields) + "'");
        }
        Field field = AbstractJdbcRepository.field((String)fields.getFirst());
        List<LikeEscapeStep> match = Arrays.stream(query.split("\\p{P}|\\p{S}|\\p{Z}")).map(s -> field.likeIgnoreCase("%" + s.toUpperCase(Locale.ROOT) + "%")).toList();
        if (match.size() == 0) {
            return DSL.falseCondition();
        }
        return DSL.and(match);
    }

    public <R extends Record, E> ArrayListTotal<E> fetchPage(DSLContext context, SelectConditionStep<R> select, Pageable pageable, RecordMapper<R, E> mapper) {
        Result results = this.limit(context.select(new SelectFieldOrAsterisk[]{DSL.asterisk(), DSL.count().over().as("total_count")}).from((TableLike)this.sort(select, pageable).asTable("page")).where((Condition)DSL.trueCondition()), pageable).fetch();
        Integer totalCount = results.size() > 0 ? (Integer)((Record)results.getFirst()).get("total_count", Integer.class) : Integer.valueOf(0);
        List map = results.map(record -> mapper.map(record));
        return new ArrayListTotal(map, (long)totalCount.intValue());
    }
}

