/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.ExecutionStatistics;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.ExecutorState;
import io.kestra.core.utils.DateUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.AbstractJdbcExecutorStateStorage;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.ResultOrRows;
import org.jooq.Results;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectForUpdateOfStep;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcExecutionRepository
extends AbstractJdbcRepository
implements ExecutionRepositoryInterface,
JdbcIndexerInterface<Execution> {
    protected final io.kestra.jdbc.AbstractJdbcRepository<Execution> jdbcRepository;
    private final ApplicationEventPublisher<CrudEvent<Execution>> eventPublisher;
    private final ApplicationContext applicationContext;
    protected final AbstractJdbcExecutorStateStorage executorStateStorage;
    private QueueInterface<Execution> executionQueue;

    public AbstractJdbcExecutionRepository(io.kestra.jdbc.AbstractJdbcRepository<Execution> jdbcRepository, ApplicationContext applicationContext, AbstractJdbcExecutorStateStorage executorStateStorage) {
        this.jdbcRepository = jdbcRepository;
        this.executorStateStorage = executorStateStorage;
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.applicationContext = applicationContext;
    }

    private QueueInterface<Execution> executionQueue() {
        if (this.executionQueue == null) {
            this.executionQueue = (QueueInterface)this.applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        }
        return this.executionQueue;
    }

    public Boolean isTaskRunEnabled() {
        return false;
    }

    public Optional<Execution> findById(String tenantId, String id) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("key").eq((Object)id));
            return this.jdbcRepository.fetchOne(from);
        });
    }

    protected abstract Condition findCondition(String var1, Map<String, String> var2);

    protected Condition statesFilter(List<State.Type> state) {
        return AbstractJdbcExecutionRepository.field("state_current").in((Collection)state.stream().map(Enum::name).collect(Collectors.toList()));
    }

    public ArrayListTotal<Execution> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<Record1<Object>> select = this.findSelect(context, query, tenantId, namespace, flowId, startDate, endDate, state, labels, triggerExecutionId);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public Flowable<Execution> find(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId) {
        return Flowable.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<Record1<Object>> select = this.findSelect(context, query, tenantId, namespace, flowId, startDate, endDate, state, labels, triggerExecutionId);
            select.fetch().map(this.jdbcRepository::map).forEach(arg_0 -> ((FlowableEmitter)emitter).onNext(arg_0));
            emitter.onComplete();
        }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    private SelectConditionStep<Record1<Object>> findSelect(DSLContext context, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId) {
        SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).hint(context.configuration().dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
        select = this.filteringQuery(select, namespace, flowId, null, query, labels, triggerExecutionId);
        if (startDate != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("start_date").greaterOrEqual((Object)startDate.toOffsetDateTime()));
        }
        if (endDate != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("end_date").lessOrEqual((Object)endDate.toOffsetDateTime()));
        }
        if (state != null) {
            select = select.and(this.statesFilter(state));
        }
        return select;
    }

    public ArrayListTotal<Execution> findByFlowId(String tenantId, String namespace, String id, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)id));
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public ArrayListTotal<TaskRun> findTaskRun(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> states, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId) {
        throw new UnsupportedOperationException();
    }

    public Integer maxTaskRunSetting() {
        throw new UnsupportedOperationException();
    }

    public List<DailyExecutionStatistics> dailyStatistics(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, boolean isTaskRun) {
        if (isTaskRun) {
            throw new UnsupportedOperationException();
        }
        Results results = this.dailyStatisticsQuery(List.of(AbstractJdbcExecutionRepository.field("state_current", String.class)), query, tenantId, namespace, flowId, null, startDate, endDate, groupBy);
        return this.dailyStatisticsQueryMapRecord((Result<Record>)((ResultOrRows)results.resultsOrRows().get(0)).result(), startDate, endDate, groupBy);
    }

    private List<DailyExecutionStatistics> dailyStatisticsQueryMapRecord(Result<Record> records, ZonedDateTime startDate, ZonedDateTime endDate, @Nullable DateUtils.GroupType groupType) {
        DateUtils.GroupType groupByType = groupType != null ? groupType : DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        return AbstractJdbcExecutionRepository.fillDate(records.stream().map(record -> ExecutionStatistics.builder().date(this.jdbcRepository.getDate(record, groupByType.val())).durationMax((Long)record.get("duration_max", Long.class)).durationMin((Long)record.get("duration_min", Long.class)).durationSum((Long)record.get("duration_sum", Long.class)).stateCurrent((String)record.get("state_current", String.class)).count((Long)record.get("count", Long.class)).build()).collect(Collectors.groupingBy(ExecutionStatistics::getDate)).entrySet().stream().map(dateResultEntry -> this.dailyExecutionStatisticsMap((Instant)dateResultEntry.getKey(), (List)dateResultEntry.getValue(), groupByType.val())).sorted(Comparator.comparing(DailyExecutionStatistics::getStartDate)).collect(Collectors.toList()), startDate, endDate);
    }

    private Results dailyStatisticsQuery(List<Field<?>> fields, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, List<ExecutionRepositoryInterface.FlowFilter> flows, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy) {
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        ArrayList dateFields = new ArrayList(this.groupByFields(Duration.between(finalStartDate, finalEndDate), "start_date", groupBy));
        ArrayList selectFields = new ArrayList(fields);
        selectFields.addAll(List.of(DSL.count().as("count"), DSL.min(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_min"), DSL.max(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_max"), DSL.sum(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_sum")));
        selectFields.addAll(dateFields);
        return (Results)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select((Collection)selectFields).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("start_date").greaterOrEqual((Object)finalStartDate.toOffsetDateTime())).and(AbstractJdbcExecutionRepository.field("start_date").lessOrEqual((Object)finalEndDate.toOffsetDateTime()));
            select = this.filteringQuery(select, namespace, flowId, flows, query, null, null);
            ArrayList groupFields = new ArrayList(fields);
            groupFields.addAll(dateFields);
            SelectHavingStep finalQuery = select.groupBy(groupFields);
            return finalQuery.fetchMany();
        });
    }

    private <T extends Record> SelectConditionStep<T> filteringQuery(SelectConditionStep<T> select, @Nullable String namespace, @Nullable String flowId, @Nullable List<ExecutionRepositoryInterface.FlowFilter> flows, @Nullable String query, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId) {
        if (flowId != null && namespace != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace));
            select = select.and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flowId));
        } else if (namespace != null) {
            select = select.and(DSL.or((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcExecutionRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
        }
        if (query != null || labels != null) {
            select = select.and(this.findCondition(query, labels));
        }
        if (triggerExecutionId != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("trigger_execution_id").eq((Object)triggerExecutionId));
        }
        if (flows != null) {
            select = select.and(DSL.or((Collection)flows.stream().map(e -> AbstractJdbcExecutionRepository.field("namespace").eq((Object)e.getNamespace()).and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)e.getId()))).collect(Collectors.toList())));
        }
        return select;
    }

    public Map<String, Map<String, List<DailyExecutionStatistics>>> dailyGroupByFlowStatistics(@Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable List<ExecutionRepositoryInterface.FlowFilter> flows, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, boolean groupByNamespaceOnly) {
        ArrayList fields = new ArrayList();
        fields.add(AbstractJdbcExecutionRepository.field("state_current", String.class));
        fields.add(AbstractJdbcExecutionRepository.field("namespace", String.class));
        if (!groupByNamespaceOnly) {
            fields.add(AbstractJdbcExecutionRepository.field("flow_id", String.class));
        }
        Results results = this.dailyStatisticsQuery(fields, query, tenantId, namespace, flowId, flows, startDate, endDate, null);
        return ((ResultOrRows)results.resultsOrRows().get(0)).result().intoGroups(AbstractJdbcExecutionRepository.field("namespace", String.class)).entrySet().stream().map(e -> {
            if (groupByNamespaceOnly) {
                return new AbstractMap.SimpleEntry<String, Map<String, List<DailyExecutionStatistics>>>((String)e.getKey(), Map.of("*", this.dailyStatisticsQueryMapRecord((Result<Record>)((Result)e.getValue()), startDate, endDate, null)));
            }
            return new AbstractMap.SimpleEntry<String, Map<String, List>>((String)e.getKey(), ((Result)e.getValue()).intoGroups(AbstractJdbcExecutionRepository.field("flow_id", String.class)).entrySet().stream().map(f -> new AbstractMap.SimpleEntry<String, List<DailyExecutionStatistics>>((String)f.getKey(), this.dailyStatisticsQueryMapRecord((Result<Record>)((Result)f.getValue()), startDate, endDate, null))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<DailyExecutionStatistics> fillDate(List<DailyExecutionStatistics> results, ZonedDateTime startDate, ZonedDateTime endDate) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        if (groupByType.equals((Object)DateUtils.GroupType.MONTH)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.MONTHS, "YYYY-MM", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.WEEK)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.WEEKS, "YYYY-ww", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.DAY)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.DAYS, "YYYY-MM-DD", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.HOUR)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.HOURS, "YYYY-MM-DD HH", groupByType.val());
        }
        return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.MINUTES, "YYYY-MM-DD HH:mm", groupByType.val());
    }

    private static List<DailyExecutionStatistics> fillDate(List<DailyExecutionStatistics> results, ZonedDateTime startDate, ZonedDateTime endDate, ChronoUnit unit, String format, String groupByType) {
        ArrayList<DailyExecutionStatistics> filledResult = new ArrayList<DailyExecutionStatistics>();
        ZonedDateTime currentDate = startDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        String formattedEndDate = endDate.plus(1L, unit).format(formatter);
        while (!currentDate.format(formatter).equals(formattedEndDate)) {
            String finalCurrentDate = currentDate.format(formatter);
            DailyExecutionStatistics dailyExecutionStatistics = results.stream().filter(e -> formatter.format(e.getStartDate()).equals(finalCurrentDate)).findFirst().orElse(DailyExecutionStatistics.builder().startDate(currentDate.toInstant()).groupBy(groupByType).duration(DailyExecutionStatistics.Duration.builder().build()).build());
            filledResult.add(dailyExecutionStatistics);
            currentDate = currentDate.plus(1L, unit);
        }
        return filledResult;
    }

    private DailyExecutionStatistics dailyExecutionStatisticsMap(Instant date, List<ExecutionStatistics> result, String groupByType) {
        long durationSum = result.stream().map(ExecutionStatistics::getDurationSum).mapToLong(value -> value).sum();
        long count = result.stream().map(ExecutionStatistics::getCount).mapToLong(value -> value).sum();
        DailyExecutionStatistics build = DailyExecutionStatistics.builder().startDate(date).groupBy(groupByType).duration(DailyExecutionStatistics.Duration.builder().avg(Duration.ofMillis(durationSum / count)).min((Duration)result.stream().map(ExecutionStatistics::getDurationMin).min(Long::compare).map(Duration::ofMillis).orElse(null)).max((Duration)result.stream().map(ExecutionStatistics::getDurationMax).max(Long::compare).map(Duration::ofMillis).orElse(null)).sum(Duration.ofMillis(durationSum)).count(count).build()).build();
        result.forEach(record -> build.getExecutionCounts().compute(State.Type.valueOf((String)record.getStateCurrent()), (type, current) -> record.getCount()));
        return build;
    }

    public List<ExecutionCount> executionCounts(@Nullable String tenantId, List<Flow> flows, @Nullable List<State.Type> states, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        List result = (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            SelectConditionStep select = dslContext.select(List.of(AbstractJdbcExecutionRepository.field("namespace"), AbstractJdbcExecutionRepository.field("flow_id"), DSL.count().as("count"))).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            if (startDate != null) {
                select = select.and(AbstractJdbcExecutionRepository.field("start_date").greaterOrEqual((Object)finalStartDate.toOffsetDateTime()));
            }
            if (endDate != null) {
                select = select.and(AbstractJdbcExecutionRepository.field("end_date").lessOrEqual((Object)finalEndDate.toOffsetDateTime()));
            }
            if (states != null) {
                select = select.and(this.statesFilter(states));
            }
            select = select.and(DSL.or((Collection)flows.stream().map(flow -> DSL.and((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)flow.getNamespace()), (Condition)AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flow.getFlowId()))).collect(Collectors.toList())));
            return ((ResultOrRows)select.groupBy(List.of(AbstractJdbcExecutionRepository.field("namespace"), AbstractJdbcExecutionRepository.field("flow_id"))).fetchMany().resultsOrRows().get(0)).result().stream().map(record -> new ExecutionCount((String)record.getValue("namespace", String.class), (String)record.getValue("flow_id", String.class), (Long)record.getValue("count", Long.class))).collect(Collectors.toList());
        });
        return flows.stream().map(flow -> result.stream().filter(executionCount -> executionCount.getNamespace().equals(flow.getNamespace()) && executionCount.getFlowId().equals(flow.getFlowId())).findFirst().orElse(new ExecutionCount(flow.getNamespace(), flow.getFlowId(), Long.valueOf(0L)))).collect(Collectors.toList());
    }

    public List<Execution> lastExecutions(@Nullable String tenantId, List<ExecutionRepositoryInterface.FlowFilter> flows) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep subquery = context.select(AbstractJdbcExecutionRepository.field("value"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{AbstractJdbcExecutionRepository.field("flow_id")}).orderBy(new OrderField[]{AbstractJdbcExecutionRepository.field("end_date").desc()})).as("row_num")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("end_date").isNotNull()).and(DSL.or((Collection)flows.stream().map(flow -> DSL.and((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)flow.getNamespace()), (Condition)AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flow.getId()))).collect(Collectors.toList())));
            Table cte = subquery.asTable("cte");
            SelectConditionStep mainQuery = context.select((SelectField)cte.field("value")).from((TableLike)cte).where(AbstractJdbcExecutionRepository.field("row_num").eq((Object)1));
            return mainQuery.fetch().map(this.jdbcRepository::map);
        });
    }

    public Execution save(Execution execution) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(execution);
        this.jdbcRepository.persist(execution, fields);
        return execution;
    }

    @Override
    public Execution save(DSLContext dslContext, Execution execution) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(execution);
        this.jdbcRepository.persist(execution, dslContext, fields);
        return execution;
    }

    public Execution delete(Execution execution) {
        Optional<Execution> revision = this.findById(execution.getTenantId(), execution.getId());
        if (revision.isEmpty()) {
            throw new IllegalStateException("Execution " + execution.getId() + " doesn't exists");
        }
        Execution deleted = execution.toDeleted();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(deleted);
        this.jdbcRepository.persist(deleted, fields);
        this.executionQueue().emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)deleted, CrudEventType.DELETE));
        return deleted;
    }

    public Integer purge(Execution execution) {
        return this.jdbcRepository.delete(execution);
    }

    public Executor lock(String executionId, Function<Pair<Execution, ExecutorState>, Pair<Executor, ExecutorState>> function) {
        return (Executor)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectForUpdateOfStep from = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcExecutionRepository.field("key").eq((Object)executionId)).and(this.defaultFilter()).forUpdate();
            Optional<Execution> execution = this.jdbcRepository.fetchOne(from);
            if (execution.isEmpty()) {
                return null;
            }
            ExecutorState executorState = this.executorStateStorage.get(context, execution.get());
            Pair pair = (Pair)function.apply(Pair.of((Object)execution.get(), (Object)executorState));
            if (pair != null) {
                this.jdbcRepository.persist(((Executor)pair.getKey()).getExecution(), context, null);
                this.executorStateStorage.save(context, (ExecutorState)pair.getRight());
                return (Executor)pair.getKey();
            }
            return null;
        });
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("id", "id", "state.startDate", "start_date", "state.endDate", "end_date", "state.duration", "state_duration", "namespace", "namespace", "flowId", "flow_id", "state.current", "state_current");
        return mapper::get;
    }
}

