/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;
import org.slf4j.event.Level;

@Singleton
public abstract class AbstractJdbcLogRepository
extends AbstractJdbcRepository
implements LogRepositoryInterface,
JdbcIndexerInterface<LogEntry> {
    protected io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository;

    public AbstractJdbcLogRepository(io.kestra.jdbc.AbstractJdbcRepository<LogEntry> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    protected abstract Condition findCondition(String var1);

    public ArrayListTotal<LogEntry> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace, @Nullable String flowId, @Nullable Level minLevel, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcLogRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcLogRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            if (flowId != null) {
                select.and(AbstractJdbcLogRepository.field("flow_id").eq((Object)flowId));
            }
            if (minLevel != null) {
                select = select.and(this.minLevel(minLevel));
            }
            if (query != null) {
                select = select.and(this.findCondition(query));
            }
            if (startDate != null) {
                select = select.and(AbstractJdbcLogRepository.field("timestamp").greaterOrEqual((Object)startDate.toOffsetDateTime()));
            }
            if (endDate != null) {
                select = select.and(AbstractJdbcLogRepository.field("timestamp").lessOrEqual((Object)endDate.toOffsetDateTime()));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public List<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionId(String tenantId, String executionId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("task_id").eq((Object)taskId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Level minLevel, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)), minLevel, pageable);
    }

    public List<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel);
    }

    public ArrayListTotal<LogEntry> findByExecutionIdAndTaskRunIdAndAttempt(String tenantId, String executionId, String taskRunId, Level minLevel, Integer attempt, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcLogRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcLogRepository.field("taskrun_id").eq((Object)taskRunId)).and(AbstractJdbcLogRepository.field("attempt_number").eq((Object)attempt)), minLevel, pageable);
    }

    public LogEntry save(LogEntry log) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(log);
        this.jdbcRepository.persist(log, fields);
        return log;
    }

    public Integer purge(Execution execution) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcLogRepository.field("execution_id", String.class).eq((Object)execution.getId())).execute();
        });
    }

    @Override
    public LogEntry save(DSLContext dslContext, LogEntry logEntry) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(logEntry);
        this.jdbcRepository.persist(logEntry, dslContext, fields);
        return logEntry;
    }

    private ArrayListTotal<LogEntry> query(String tenantId, Condition condition, Level minLevel, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcLogRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private List<LogEntry> query(String tenantId, Condition condition, Level minLevel) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcLogRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (minLevel != null) {
                select.and(this.minLevel(minLevel));
            }
            return this.jdbcRepository.fetch(select.orderBy((OrderField)AbstractJdbcLogRepository.field("timestamp").sort(SortOrder.ASC)));
        });
    }

    protected Condition minLevel(Level minLevel) {
        return AbstractJdbcLogRepository.field("level").in((Collection)LogEntry.findLevelsByMin((Level)minLevel));
    }
}

