/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.executions.metrics.MetricAggregation;
import io.kestra.core.models.executions.metrics.MetricAggregations;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.MetricRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micrometer.common.lang.Nullable;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcMetricRepository
extends AbstractJdbcRepository
implements MetricRepositoryInterface,
JdbcIndexerInterface<MetricEntry> {
    protected io.kestra.jdbc.AbstractJdbcRepository<MetricEntry> jdbcRepository;

    public AbstractJdbcMetricRepository(io.kestra.jdbc.AbstractJdbcRepository<MetricEntry> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public ArrayListTotal<MetricEntry> findByExecutionId(String tenantId, String executionId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId), pageable);
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId)), pageable);
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcMetricRepository.field("taskrun_id").eq((Object)taskRunId)), pageable);
    }

    public List<String> flowMetrics(String tenantId, String namespace, String flowId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)), "metric_name");
    }

    public List<String> taskMetrics(String tenantId, String namespace, String flowId, String taskId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId)), "metric_name");
    }

    public List<String> tasksWithMetrics(String tenantId, String namespace, String flowId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)), "task_id");
    }

    public MetricAggregations aggregateByFlowId(String tenantId, String namespace, String flowId, @Nullable String taskId, String metric, ZonedDateTime startDate, ZonedDateTime endDate, String aggregation) {
        Condition conditions = AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcMetricRepository.field("metric_name").eq((Object)metric));
        if (taskId != null) {
            conditions = conditions.and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId));
        }
        return MetricAggregations.builder().aggregations(this.aggregate(tenantId, conditions, startDate, endDate, aggregation)).groupBy(DateUtils.groupByType((Duration)Duration.between(startDate, endDate)).val()).build();
    }

    public MetricEntry save(MetricEntry metric) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(metric);
        this.jdbcRepository.persist(metric, fields);
        return metric;
    }

    public Integer purge(Execution execution) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcMetricRepository.field("execution_id", String.class).eq((Object)execution.getId())).execute();
        });
    }

    @Override
    public MetricEntry save(DSLContext dslContext, MetricEntry metric) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(metric);
        this.jdbcRepository.persist(metric, dslContext, fields);
        return metric;
    }

    private List<String> queryDistinct(String tenantId, Condition condition, String field) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = DSL.using((Configuration)configuration).selectDistinct(AbstractJdbcMetricRepository.field(field)).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            return select.fetch().map(record -> (String)record.get(field, String.class));
        });
    }

    private ArrayListTotal<MetricEntry> query(String tenantId, Condition condition, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcMetricRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private List<MetricAggregation> aggregate(String tenantId, Condition condition, ZonedDateTime startDate, ZonedDateTime endDate, String aggregation) {
        ArrayList dateFields = new ArrayList(this.groupByFields(Duration.between(startDate, endDate)));
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select((Collection)dateFields).select(new SelectFieldOrAsterisk[]{AbstractJdbcMetricRepository.field("metric_name"), this.aggregate(aggregation)}).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (startDate != null) {
                select = select.and(AbstractJdbcMetricRepository.field("timestamp").greaterOrEqual((Object)startDate.toOffsetDateTime()));
            }
            if (endDate != null) {
                select = select.and(AbstractJdbcMetricRepository.field("timestamp").lessOrEqual((Object)endDate.toOffsetDateTime()));
            }
            dateFields.add(AbstractJdbcMetricRepository.field("metric_name"));
            SelectHavingStep selectGroup = select.groupBy((Collection)dateFields);
            List<MetricAggregation> result = this.jdbcRepository.fetchMetricStat((Select<Record>)selectGroup, DateUtils.groupByType((Duration)Duration.between(startDate, endDate)).val());
            List<MetricAggregation> fillResult = this.fillDate(result, startDate, endDate);
            return fillResult;
        });
    }

    private Field<?> aggregate(String aggregation) {
        return switch (aggregation) {
            case "avg" -> DSL.avg(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "sum" -> DSL.sum(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "min" -> DSL.min(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "max" -> DSL.max(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            default -> throw new IllegalArgumentException("Invalid aggregation: " + aggregation);
        };
    }

    private List<MetricAggregation> fillDate(List<MetricAggregation> result, ZonedDateTime startDate, ZonedDateTime endDate) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        if (groupByType.equals((Object)DateUtils.GroupType.MONTH)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.MONTHS, "YYYY-MM");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.WEEK)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.WEEKS, "YYYY-ww");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.DAY)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.DAYS, "YYYY-MM-DD");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.HOUR)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.HOURS, "YYYY-MM-DD HH");
        }
        return this.fillDate(result, startDate, endDate, ChronoUnit.MINUTES, "YYYY-MM-DD HH:mm");
    }

    private List<MetricAggregation> fillDate(List<MetricAggregation> result, ZonedDateTime startDate, ZonedDateTime endDate, ChronoUnit unit, String format) {
        ArrayList<MetricAggregation> filledResult = new ArrayList<MetricAggregation>();
        ZonedDateTime currentDate = startDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        while (currentDate.isBefore(endDate)) {
            String finalCurrentDate = currentDate.format(formatter);
            MetricAggregation metricStat = result.stream().filter(metric -> formatter.format(metric.date).equals(finalCurrentDate)).findFirst().orElse(MetricAggregation.builder().date(currentDate.toInstant()).value(Double.valueOf(0.0)).build());
            filledResult.add(metricStat);
            currentDate = currentDate.plus(1L, unit);
        }
        return filledResult;
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("namespace", "namespace", "flowId", "flow_id", "taskId", "task_id", "executionId", "execution_id", "taskrunId", "taskrun_id", "name", "metric_name", "timestamp", "timestamp", "value", "metric_value");
        return mapper::get;
    }
}

