/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.utils.DateUtils;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcRepository {
    protected Condition defaultFilter() {
        return AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false);
    }

    protected Condition defaultFilter(String tenantId) {
        Condition tenant = this.buildTenantCondition(tenantId);
        return tenant.and(AbstractJdbcRepository.field("deleted", Boolean.class).eq((Object)false));
    }

    protected Condition buildTenantCondition(String tenantId) {
        return tenantId == null ? AbstractJdbcRepository.field("tenant_id").isNull() : AbstractJdbcRepository.field("tenant_id").eq((Object)tenantId);
    }

    public static Field<Object> field(String name) {
        return DSL.field((Name)DSL.quotedName((String)name));
    }

    public static <T> Field<T> field(String name, Class<T> cls) {
        return DSL.field((Name)DSL.quotedName((String)name), cls);
    }

    protected List<Field<?>> groupByFields(Duration duration) {
        return this.groupByFields(duration, null, null);
    }

    protected List<Field<?>> groupByFields(Duration duration, @Nullable String dateField, @Nullable DateUtils.GroupType groupBy) {
        String field = dateField != null ? dateField : "timestamp";
        Field month = DSL.month((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("month");
        Field year = DSL.year((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("year");
        Field day = DSL.day((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("day");
        Field week = DSL.week((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("week");
        Field hour = DSL.hour((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("hour");
        Field minute = DSL.minute((Field)DSL.timestamp(AbstractJdbcRepository.field(field, Date.class))).as("minute");
        if (groupBy == DateUtils.GroupType.MONTH || duration.toDays() > (long)DateUtils.GroupValue.MONTH.getValue()) {
            return List.of(year, month);
        }
        if (groupBy == DateUtils.GroupType.WEEK || duration.toDays() > (long)DateUtils.GroupValue.WEEK.getValue()) {
            return List.of(year, week);
        }
        if (groupBy == DateUtils.GroupType.DAY || duration.toDays() > (long)DateUtils.GroupValue.DAY.getValue()) {
            return List.of(year, month, day);
        }
        if (groupBy == DateUtils.GroupType.HOUR || duration.toHours() > (long)DateUtils.GroupValue.HOUR.getValue()) {
            return List.of(year, month, day, hour);
        }
        return List.of(year, month, day, hour, minute);
    }
}

