/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.Setting;
import io.kestra.core.repositories.SettingRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcSettingRepository
extends AbstractJdbcRepository
implements SettingRepositoryInterface {
    protected final io.kestra.jdbc.AbstractJdbcRepository<Setting> jdbcRepository;
    private final ApplicationEventPublisher<CrudEvent<Setting>> eventPublisher;

    public AbstractJdbcSettingRepository(io.kestra.jdbc.AbstractJdbcRepository<Setting> jdbcRepository, ApplicationContext applicationContext) {
        this.jdbcRepository = jdbcRepository;
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
    }

    public Boolean isTaskRunEnabled() {
        return false;
    }

    public Optional<Setting> findByKey(String key) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcSettingRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcSettingRepository.field("key").eq((Object)key));
            return this.jdbcRepository.fetchOne(from);
        });
    }

    public List<Setting> findAll() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectJoinStep select = DSL.using((Configuration)configuration).select(AbstractJdbcSettingRepository.field("value")).from(this.jdbcRepository.getTable());
            return this.jdbcRepository.fetch(select);
        });
    }

    public Setting save(Setting setting) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(setting);
        this.jdbcRepository.persist(setting, fields);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)setting, CrudEventType.UPDATE));
        return setting;
    }

    public Setting delete(Setting setting) {
        Optional<Setting> get = this.findByKey(setting.getKey());
        if (get.isEmpty()) {
            throw new IllegalStateException("Setting " + setting.getKey() + " doesn't exists");
        }
        this.jdbcRepository.delete(setting);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)setting, CrudEventType.DELETE));
        return setting;
    }
}

