/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.events.CrudEventType;
import io.kestra.core.models.templates.Template;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TemplateRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.GroupField;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcTemplateRepository
extends AbstractJdbcRepository
implements TemplateRepositoryInterface {
    private final QueueInterface<Template> templateQueue;
    private final ApplicationEventPublisher<CrudEvent<Template>> eventPublisher;
    protected io.kestra.jdbc.AbstractJdbcRepository<Template> jdbcRepository;

    public AbstractJdbcTemplateRepository(io.kestra.jdbc.AbstractJdbcRepository<Template> jdbcRepository, ApplicationContext applicationContext) {
        this.jdbcRepository = jdbcRepository;
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.templateQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"templateQueue"));
    }

    public Optional<Template> findById(String tenantId, String namespace, String id) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcTemplateRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcTemplateRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcTemplateRepository.field("id").eq((Object)id));
            return this.jdbcRepository.fetchOne(from);
        });
    }

    public List<Template> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTemplateRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Template> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTemplateRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter());
            return this.jdbcRepository.fetch(select);
        });
    }

    protected abstract Condition findCondition(String var1);

    public ArrayListTotal<Template> find(Pageable pageable, @Nullable String query, @Nullable String tenantId, @Nullable String namespace) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcTemplateRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            if (query != null) {
                select.and(this.findCondition(query));
            }
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcTemplateRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcTemplateRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public List<Template> find(@Nullable String query, @Nullable String tenantId, @Nullable String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcTemplateRepository.field("value")).hint(configuration.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            if (query != null) {
                select.and(this.findCondition(query));
            }
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcTemplateRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcTemplateRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Template> findByNamespace(String tenantId, String namespace) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTemplateRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTemplateRepository.field("namespace").eq((Object)namespace)).and(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public Template create(Template template) throws ConstraintViolationException {
        this.jdbcRepository.persist(template);
        this.templateQueue.emit((Object)template);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)template, CrudEventType.CREATE));
        return template;
    }

    public Template update(Template template, Template previous) throws ConstraintViolationException {
        this.findById(previous.getTenantId(), previous.getNamespace(), previous.getId()).map(current -> current.validateUpdate(template)).filter(Optional::isPresent).map(Optional::get).ifPresent(s -> {
            throw s;
        });
        this.jdbcRepository.persist(template);
        this.templateQueue.emit((Object)template);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)template, CrudEventType.UPDATE));
        return template;
    }

    public void delete(Template template) {
        if (this.findById(template.getTenantId(), template.getNamespace(), template.getId()).isEmpty()) {
            throw new IllegalStateException("Template " + template.getId() + " doesn't exists");
        }
        Template deleted = template.toDeleted();
        this.jdbcRepository.persist(deleted);
        this.templateQueue.emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)new CrudEvent((Object)deleted, CrudEventType.DELETE));
    }

    public List<String> findDistinctNamespace(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> DSL.using((Configuration)configuration).select(AbstractJdbcTemplateRepository.field("namespace")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).groupBy(new GroupField[]{AbstractJdbcTemplateRepository.field("namespace")}).fetch().map(record -> (String)record.getValue("namespace", String.class)));
    }
}

