/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.TriggerRepositoryInterface;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;

@Singleton
public abstract class AbstractJdbcTriggerRepository
extends AbstractJdbcRepository
implements TriggerRepositoryInterface,
JdbcIndexerInterface<Trigger> {
    protected io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository;

    public AbstractJdbcTriggerRepository(io.kestra.jdbc.AbstractJdbcRepository<Trigger> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<Trigger> findLast(TriggerContext trigger) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("key").eq((Object)trigger.uid()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public Optional<Trigger> findByExecution(Execution execution) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcTriggerRepository.field("execution_id").eq((Object)execution.getId()));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public List<Trigger> findAllForAllTenants() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectJoinStep select = DSL.using((Configuration)configuration).select(AbstractJdbcTriggerRepository.field("value")).from(this.jdbcRepository.getTable());
            return this.jdbcRepository.fetch(select);
        });
    }

    public Trigger save(Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, fields);
        return trigger;
    }

    @Override
    public Trigger save(DSLContext dslContext, Trigger trigger) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(trigger);
        this.jdbcRepository.persist(trigger, dslContext, fields);
        return trigger;
    }

    public void delete(Trigger trigger) {
        this.jdbcRepository.delete(trigger);
    }

    public ArrayListTotal<Trigger> find(Pageable pageable, String query, String tenantId, String namespace) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcTriggerRepository.field("value")).hint(context.dialect() == SQLDialect.MYSQL ? "SQL_CALC_FOUND_ROWS" : null).from(this.jdbcRepository.getTable()).where(this.fullTextCondition(query)).and(this.defaultFilter(tenantId));
            if (namespace != null) {
                select.and(DSL.or((Condition)AbstractJdbcTriggerRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcTriggerRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
            }
            select.and(this.defaultFilter());
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    protected Condition fullTextCondition(String query) {
        return query == null ? DSL.trueCondition() : this.jdbcRepository.fullTextCondition(List.of("fulltext"), query);
    }

    @Override
    protected Condition defaultFilter(String tenantId) {
        return this.buildTenantCondition(tenantId);
    }

    @Override
    protected Condition defaultFilter() {
        return DSL.trueCondition();
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("flowId", "flow_id", "triggerId", "trigger_id", "executionId", "execution_id");
        return s -> mapper.getOrDefault(s, (String)s);
    }
}

