/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.repositories.WorkerInstanceRepositoryInterface;
import io.kestra.core.runners.WorkerInstance;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.jooq.SelectForUpdateOfStep;
import org.jooq.SelectJoinStep;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class AbstractJdbcWorkerInstanceRepository
extends AbstractJdbcRepository
implements WorkerInstanceRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcWorkerInstanceRepository.class);
    protected io.kestra.jdbc.AbstractJdbcRepository<WorkerInstance> jdbcRepository;
    @Value(value="${kestra.heartbeat.frequency}")
    private Duration frequency;
    @Value(value="${kestra.heartbeat.heartbeat-missed}")
    private Integer nbMissed;

    public AbstractJdbcWorkerInstanceRepository(io.kestra.jdbc.AbstractJdbcRepository<WorkerInstance> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<WorkerInstance> findByWorkerUuid(String workerUuid) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep<Record1<Object>> select = this.heartbeatSelectQuery(DSL.using((Configuration)configuration), workerUuid);
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public Optional<WorkerInstance> heartbeatCheckUp(String workerUuid) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectForUpdateOfStep select = this.heartbeatSelectQuery(DSL.using((Configuration)configuration), workerUuid).forUpdate();
            Optional<WorkerInstance> workerInstance = this.jdbcRepository.fetchOne(select);
            if (workerInstance.isPresent()) {
                WorkerInstance updatedWorker = workerInstance.get().toBuilder().status(WorkerInstance.Status.UP).heartbeatDate(Instant.now()).build();
                this.save(updatedWorker);
                return Optional.of(updatedWorker);
            }
            return Optional.empty();
        });
    }

    public void heartbeatStatusUpdate(String workerUuid, DSLContext context) {
        SelectForUpdateOfStep select = this.heartbeatSelectQuery(context, workerUuid).and(AbstractJdbcWorkerInstanceRepository.field("status").eq((Object)WorkerInstance.Status.UP.toString())).and(AbstractJdbcWorkerInstanceRepository.field("heartbeat_date").lessThan((Object)Instant.now().minusSeconds((long)this.getNbMissed().intValue() * this.getFrequency().getSeconds()))).forUpdate();
        Optional<WorkerInstance> workerInstance = this.jdbcRepository.fetchOne(select);
        workerInstance.ifPresent(heartbeat -> {
            heartbeat.setStatus(WorkerInstance.Status.DEAD);
            log.warn("Detected evicted worker: {}", heartbeat);
            this.jdbcRepository.persist((WorkerInstance)heartbeat, context, this.jdbcRepository.persistFields((WorkerInstance)heartbeat));
        });
    }

    public void heartbeatsStatusUpdate(DSLContext context) {
        this.findAllAlive(context).forEach(heartbeat -> this.heartbeatStatusUpdate(heartbeat.getWorkerUuid().toString(), context));
    }

    public void lockedWorkersUpdate(Function<DSLContext, Void> function) {
        this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            this.heartbeatsStatusUpdate(context);
            function.apply(context);
            return null;
        });
    }

    public List<WorkerInstance> findAll(DSLContext context) {
        return this.jdbcRepository.fetch(this.heartbeatSelectAllQuery(context));
    }

    public List<WorkerInstance> findAll() {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return this.jdbcRepository.fetch(this.heartbeatSelectAllQuery(context));
        });
    }

    public List<WorkerInstance> findAllAlive(DSLContext context) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.jdbcRepository.fetch(this.heartbeatSelectAllQuery(context).where(AbstractJdbcWorkerInstanceRepository.field("status").eq((Object)WorkerInstance.Status.UP.toString()))));
    }

    public List<WorkerInstance> findAllToDelete(DSLContext context) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> this.jdbcRepository.fetch(this.heartbeatSelectAllQuery(context).where(AbstractJdbcWorkerInstanceRepository.field("status").eq((Object)WorkerInstance.Status.DEAD.toString())).and(AbstractJdbcWorkerInstanceRepository.field("heartbeat_date").lessThan((Object)Instant.now().minusSeconds((long)(2 * this.getNbMissed()) * this.getFrequency().getSeconds())))));
    }

    public void delete(DSLContext context, WorkerInstance workerInstance) {
        this.jdbcRepository.delete(context, workerInstance);
    }

    public void delete(WorkerInstance workerInstance) {
        this.jdbcRepository.delete(workerInstance);
    }

    public WorkerInstance save(WorkerInstance workerInstance) {
        this.jdbcRepository.persist(workerInstance, this.jdbcRepository.persistFields(workerInstance));
        return workerInstance;
    }

    private SelectConditionStep<Record1<Object>> heartbeatSelectQuery(DSLContext context, String workerUuid) {
        return context.select(AbstractJdbcWorkerInstanceRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcWorkerInstanceRepository.field("worker_uuid").eq((Object)workerUuid));
    }

    private SelectJoinStep<Record1<Object>> heartbeatSelectAllQuery(DSLContext dsl) {
        return dsl.select(AbstractJdbcWorkerInstanceRepository.field("value")).from(this.jdbcRepository.getTable());
    }

    @Generated
    public io.kestra.jdbc.AbstractJdbcRepository<WorkerInstance> getJdbcRepository() {
        return this.jdbcRepository;
    }

    @Generated
    public Duration getFrequency() {
        return this.frequency;
    }

    @Generated
    public Integer getNbMissed() {
        return this.nbMissed;
    }
}

