/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.ExecutorState;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;

public abstract class AbstractJdbcExecutorStateStorage {
    protected AbstractJdbcRepository<ExecutorState> jdbcRepository;

    public AbstractJdbcExecutorStateStorage(AbstractJdbcRepository<ExecutorState> jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public ExecutorState get(DSLContext dslContext, Execution execution) {
        SelectConditionStep select = dslContext.select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable()).where(io.kestra.jdbc.repository.AbstractJdbcRepository.field("key").eq((Object)execution.getId()));
        return this.jdbcRepository.fetchOne(select).orElse(new ExecutorState(execution.getId()));
    }

    public void save(DSLContext dslContext, ExecutorState executorState) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(executorState);
        this.jdbcRepository.persist(executorState, dslContext, fields);
    }

    public void delete(Execution execution) {
        this.jdbcRepository.delete(new ExecutorState(execution.getId()));
    }
}

