/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.jdbc.AbstractJdbcRepository;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;

public abstract class AbstractJdbcWorkerTaskExecutionStorage
extends io.kestra.jdbc.repository.AbstractJdbcRepository {
    protected AbstractJdbcRepository<WorkerTaskExecution<?>> jdbcRepository;

    public AbstractJdbcWorkerTaskExecutionStorage(AbstractJdbcRepository jdbcRepository) {
        this.jdbcRepository = jdbcRepository;
    }

    public Optional<WorkerTaskExecution<?>> get(String executionId) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(io.kestra.jdbc.repository.AbstractJdbcRepository.field("value")).from(this.jdbcRepository.getTable()).where(io.kestra.jdbc.repository.AbstractJdbcRepository.field("key").eq((Object)executionId));
            return this.jdbcRepository.fetchOne(select);
        });
    }

    public void save(List<WorkerTaskExecution<?>> workerTaskExecutions) {
        this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            workerTaskExecutions.forEach(workerTaskExecution -> {
                Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields((WorkerTaskExecution<?>)workerTaskExecution);
                this.jdbcRepository.persist((WorkerTaskExecution<?>)workerTaskExecution, context, fields);
            });
        });
    }

    public void delete(WorkerTaskExecution<?> workerTaskExecution) {
        this.jdbcRepository.delete(workerTaskExecution);
    }
}

