/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.runners.Worker;
import io.kestra.core.runners.WorkerInstance;
import io.kestra.jdbc.repository.AbstractJdbcWorkerInstanceRepository;
import io.kestra.jdbc.runner.JdbcRunnerEnabled;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@JdbcRunnerEnabled
@Requires(property="kestra.server-type", pattern="(WORKER|STANDALONE)")
public class JdbcHeartbeat {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcHeartbeat.class);
    private static final String HOSTNAME;
    @Inject
    AbstractJdbcWorkerInstanceRepository workerInstanceRepository;
    private volatile WorkerInstance workerInstance;
    private final ApplicationContext applicationContext;

    public JdbcHeartbeat(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkerInstance(Worker worker) {
        JdbcHeartbeat jdbcHeartbeat = this;
        synchronized (jdbcHeartbeat) {
            if (this.workerInstance == null) {
                this.workerInstance = WorkerInstance.builder().workerUuid(UUID.randomUUID()).hostname(HOSTNAME).port(this.applicationContext.getEnvironment().getProperty("micronaut.server.port", Integer.class).orElse(8080)).managementPort(this.applicationContext.getEnvironment().getProperty("endpoints.all.port", Integer.class).orElse(8081)).workerGroup(worker.getWorkerGroup()).build();
                if (log.isDebugEnabled()) {
                    log.debug("Registered WorkerInstance of: {}", (Object)this.workerInstance.getWorkerUuid());
                }
                this.workerInstanceRepository.save(this.workerInstance);
            }
        }
    }

    @Scheduled(fixedDelay="${kestra.heartbeat.frequency}")
    public void updateHeartbeat() {
        if (this.applicationContext.containsBean(Worker.class) && !this.applicationContext.getEnvironment().getActiveNames().contains("test")) {
            if (this.workerInstance == null) {
                this.registerWorkerInstance((Worker)this.applicationContext.getBean(Worker.class));
            }
            if (log.isTraceEnabled()) {
                log.error("Heartbeat of: {}", (Object)this.workerInstance.getWorkerUuid());
            }
            if (this.workerInstanceRepository.heartbeatCheckUp(this.workerInstance.getWorkerUuid().toString()).isEmpty()) {
                log.error("heartbeatCheckUp failed, unable to find current instance '{}', Shutting down now!", (Object)this.workerInstance.getWorkerUuid());
                Runtime.getRuntime().exit(1);
            }
        }
    }

    public WorkerInstance get() {
        if (this.workerInstance == null) {
            this.registerWorkerInstance((Worker)this.applicationContext.getBean(Worker.class));
        }
        return this.workerInstance;
    }

    static {
        try {
            HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

