/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.runner;

import io.kestra.core.metrics.MetricRegistry;
import io.kestra.jdbc.runner.JdbcIndexerInterface;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JdbcQueueIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcQueueIndexer.class);
    private final Map<Class<?>, JdbcIndexerInterface<?>> repositories = new HashMap();
    private final MetricRegistry metricRegistry;

    @Inject
    public JdbcQueueIndexer(ApplicationContext applicationContext) {
        applicationContext.getBeansOfType(JdbcIndexerInterface.class).forEach(saveRepositoryInterface -> {
            String typeName = ((ParameterizedType)((Class)saveRepositoryInterface.getClass().getGenericSuperclass()).getGenericInterfaces()[1]).getActualTypeArguments()[0].getTypeName();
            try {
                this.repositories.put(Class.forName(typeName), (JdbcIndexerInterface<?>)saveRepositoryInterface);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
    }

    public void accept(DSLContext context, Object item) {
        if (this.repositories.containsKey(item.getClass())) {
            this.metricRegistry.counter("indexer.request.count", new String[]{"type", item.getClass().getName()}).increment();
            this.metricRegistry.counter("indexer.message.in.count", new String[]{"type", item.getClass().getName()}).increment();
            this.metricRegistry.timer("indexer.request.duration", new String[]{"type", item.getClass().getName()}).record(() -> {
                this.repositories.get(item.getClass()).save(context, JdbcQueueIndexer.cast(item));
                this.metricRegistry.counter("indexer.message.out.count", new String[]{"type", item.getClass().getName()}).increment();
            });
        }
    }

    protected static <T> T cast(Object message) {
        return (T)message;
    }
}

