/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.Dashboard;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.models.dashboards.charts.DataChartKPI;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.DashboardRepositoryInterface;
import io.kestra.core.repositories.QueryBuilderInterface;
import io.kestra.core.utils.MathUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.plugin.core.dashboard.chart.kpis.KpiOption;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcDashboardRepository
extends AbstractJdbcRepository
implements DashboardRepositoryInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcDashboardRepository.class);
    protected io.kestra.jdbc.AbstractJdbcRepository<Dashboard> jdbcRepository;
    private final ApplicationEventPublisher<CrudEvent<Dashboard>> eventPublisher;
    List<QueryBuilderInterface<?>> queryBuilders;

    public long count() {
        return this.jdbcRepository.count(this.defaultFilter());
    }

    public Optional<Dashboard> get(String tenantId, String id) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep from = context.select(AbstractJdbcDashboardRepository.field("source_code", String.class), AbstractJdbcDashboardRepository.field("value", String.class)).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcDashboardRepository.field("id", String.class).eq((Object)id));
            Record2 fetched = (Record2)from.fetchAny();
            if (fetched == null) {
                return Optional.empty();
            }
            Dashboard dashboard = this.jdbcRepository.map(fetched);
            return Optional.of(dashboard.toBuilder().sourceCode((String)fetched.get("source_code", String.class)).build());
        });
    }

    protected abstract Condition findCondition(String var1);

    public ArrayListTotal<Dashboard> list(Pageable pageable, String tenantId, String query) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcDashboardRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(this.findCondition(query));
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public List<Dashboard> findAll(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcDashboardRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public List<Dashboard> findAllWithNoAcl(String tenantId) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcDashboardRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilterWithNoACL(tenantId));
            return this.jdbcRepository.fetch(select);
        });
    }

    public Dashboard save(Dashboard previousDashboard, Dashboard dashboard, String source) throws ConstraintViolationException {
        dashboard = dashboard.toBuilder().sourceCode(source).build();
        if (previousDashboard != null && previousDashboard.equals((Object)dashboard)) {
            return previousDashboard;
        }
        dashboard = previousDashboard == null ? dashboard.toBuilder().created(Instant.now()).updated(Instant.now()).build() : dashboard.toBuilder().id(previousDashboard.getId()).created(previousDashboard.getCreated()).updated(Instant.now()).build();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(dashboard);
        fields.remove(AbstractJdbcDashboardRepository.field("sourceCode"));
        fields.put(AbstractJdbcDashboardRepository.field("source_code"), source);
        this.jdbcRepository.persist(dashboard, fields);
        this.eventPublisher.publishEvent((Object)CrudEvent.of((Object)previousDashboard, (Object)dashboard));
        return dashboard;
    }

    public Dashboard delete(String tenantId, String id) {
        Optional<Dashboard> dashboard = this.get(tenantId, id);
        if (dashboard.isEmpty()) {
            throw new IllegalStateException("Dashboard " + id + " doesn't exists");
        }
        Dashboard deleted = dashboard.get().toDeleted();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(deleted);
        fields.remove(AbstractJdbcDashboardRepository.field("sourceCode"));
        fields.put(AbstractJdbcDashboardRepository.field("source_code"), deleted.getSourceCode());
        this.jdbcRepository.persist(deleted, fields);
        this.eventPublisher.publishEvent((Object)CrudEvent.delete((Object)dashboard.get()));
        return deleted;
    }

    public <F extends Enum<F>> ArrayListTotal<Map<String, Object>> generate(String tenantId, DataChart<?, DataFilter<F, ? extends ColumnDescriptor<F>>> dataChart, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) throws IOException {
        HashMap<Class, QueryBuilderInterface> queryBuilderByHandledFields = new HashMap<Class, QueryBuilderInterface>();
        QueryBuilderInterface queryBuilder = queryBuilderByHandledFields.computeIfAbsent(dataChart.getData().repositoryClass(), clazz -> this.queryBuilders.stream().filter(b -> clazz.isAssignableFrom(b.getClass())).findFirst().orElseThrow(() -> new UnsupportedOperationException("No query builder found for " + String.valueOf(clazz))));
        return queryBuilder.fetchData(tenantId, dataChart.getData(), startDate, endDate, pageable);
    }

    public <F extends Enum<F>> List<Map<String, Object>> generateKPI(String tenantId, DataChartKPI<?, DataFilterKPI<F, ? extends ColumnDescriptor<F>>> dataChart, ZonedDateTime startDate, ZonedDateTime endDate) throws IOException {
        HashMap<Class, QueryBuilderInterface> queryBuilderByHandledFields = new HashMap<Class, QueryBuilderInterface>();
        QueryBuilderInterface queryBuilder = queryBuilderByHandledFields.computeIfAbsent(dataChart.getData().repositoryClass(), clazz -> this.queryBuilders.stream().filter(b -> clazz.isAssignableFrom(b.getClass())).findFirst().orElseThrow(() -> new UnsupportedOperationException("No query builder found for " + String.valueOf(clazz))));
        Double filteredValue = queryBuilder.fetchValue(tenantId, dataChart.getData(), startDate, endDate, true);
        if (dataChart.getChartOptions() != null && ((KpiOption)dataChart.getChartOptions()).getNumberType().equals((Object)KpiOption.NumberType.PERCENTAGE)) {
            Double totalValue = queryBuilder.fetchValue(tenantId, dataChart.getData(), startDate, endDate, false);
            if (totalValue == null || totalValue == 0.0) {
                return List.of(Map.of("value", 0.0));
            }
            Double percentageValue = filteredValue / totalValue * 100.0;
            return List.of(Map.of("value", MathUtils.roundDouble((double)percentageValue, (int)2)));
        }
        return List.of(Map.of("value", MathUtils.roundDouble((double)filteredValue, (int)2)));
    }

    public Boolean isEnabled() {
        return true;
    }

    @ConstructorProperties(value={"jdbcRepository", "eventPublisher", "queryBuilders"})
    @Generated
    public AbstractJdbcDashboardRepository(io.kestra.jdbc.AbstractJdbcRepository<Dashboard> jdbcRepository, ApplicationEventPublisher<CrudEvent<Dashboard>> eventPublisher, List<QueryBuilderInterface<?>> queryBuilders) {
        this.jdbcRepository = jdbcRepository;
        this.eventPublisher = eventPublisher;
        this.queryBuilders = queryBuilders;
    }
}

