/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.events.CrudEvent;
import io.kestra.core.models.Label;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.EqualTo;
import io.kestra.core.models.dashboards.filters.In;
import io.kestra.core.models.dashboards.filters.NotEqualTo;
import io.kestra.core.models.dashboards.filters.NotIn;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.ExecutionStatistics;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.ExecutorState;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.NamespaceUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.runner.AbstractJdbcExecutorStateStorage;
import io.kestra.jdbc.runner.JdbcQueueIndexerInterface;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.data.model.Pageable;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.ResultOrRows;
import org.jooq.Results;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectForUpdateOfStep;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSeekStepN;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public abstract class AbstractJdbcExecutionRepository
extends AbstractJdbcRepository
implements ExecutionRepositoryInterface,
JdbcQueueIndexerInterface<Execution> {
    private static final int FETCH_SIZE = 100;
    private static final Field<String> STATE_CURRENT_FIELD = AbstractJdbcExecutionRepository.field("state_current", String.class);
    private static final Field<String> NAMESPACE_FIELD = AbstractJdbcExecutionRepository.field("namespace", String.class);
    private static final Field<Object> START_DATE_FIELD = AbstractJdbcExecutionRepository.field("start_date");
    private static final Condition NORMAL_KIND_CONDITION = AbstractJdbcExecutionRepository.field("kind").isNull();
    protected final io.kestra.jdbc.AbstractJdbcRepository<Execution> jdbcRepository;
    private final ApplicationEventPublisher<CrudEvent<Execution>> eventPublisher;
    private final ApplicationContext applicationContext;
    protected final AbstractJdbcExecutorStateStorage executorStateStorage;
    private QueueInterface<Execution> executionQueue;
    private final NamespaceUtils namespaceUtils;
    private final JdbcFilterService filterService;
    private final Map<IExecutions.Fields, String> fieldsMapping = Map.of(IExecutions.Fields.ID, "key", IExecutions.Fields.NAMESPACE, "namespace", IExecutions.Fields.FLOW_ID, "flow_id", IExecutions.Fields.STATE, "state_current", IExecutions.Fields.DURATION, "state_duration", IExecutions.Fields.LABELS, "labels", IExecutions.Fields.START_DATE, "start_date", IExecutions.Fields.END_DATE, "end_date", IExecutions.Fields.TRIGGER_EXECUTION_ID, "trigger_execution_id");

    public Set<IExecutions.Fields> dateFields() {
        return Set.of(IExecutions.Fields.START_DATE, IExecutions.Fields.END_DATE);
    }

    public IExecutions.Fields dateFilterField() {
        return IExecutions.Fields.START_DATE;
    }

    public AbstractJdbcExecutionRepository(io.kestra.jdbc.AbstractJdbcRepository<Execution> jdbcRepository, ApplicationContext applicationContext, AbstractJdbcExecutorStateStorage executorStateStorage, JdbcFilterService filterService) {
        this.jdbcRepository = jdbcRepository;
        this.executorStateStorage = executorStateStorage;
        this.eventPublisher = (ApplicationEventPublisher)applicationContext.getBean(ApplicationEventPublisher.class);
        this.namespaceUtils = (NamespaceUtils)applicationContext.getBean(NamespaceUtils.class);
        this.applicationContext = applicationContext;
        this.filterService = filterService;
    }

    private QueueInterface<Execution> executionQueue() {
        if (this.executionQueue == null) {
            this.executionQueue = (QueueInterface)this.applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        }
        return this.executionQueue;
    }

    public Boolean isTaskRunEnabled() {
        return false;
    }

    public Flux<Execution> findAllByTriggerExecutionId(String tenantId, String triggerExecutionId) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("trigger_execution_id").eq((Object)triggerExecutionId));
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(this.jdbcRepository::map).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public Optional<Execution> findLatestForStates(String tenantId, String namespace, String flowId, List<State.Type> states) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectSeekStep1 from = DSL.using((Configuration)configuration).select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId, false)).and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flowId)).and(this.statesFilter(states)).orderBy((OrderField)AbstractJdbcExecutionRepository.field("start_date").desc());
            return this.jdbcRepository.fetchOne(from);
        });
    }

    public Optional<Execution> findById(String tenantId, String id, boolean allowDeleted) {
        return this.findById(tenantId, id, allowDeleted, true);
    }

    public Optional<Execution> findByIdWithoutAcl(String tenantId, String id) {
        return this.findById(tenantId, id, false, false);
    }

    public Optional<Execution> findById(String tenantId, String id, boolean allowDeleted, boolean withAccessControl) {
        return (Optional)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep from = DSL.using((Configuration)configuration).select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(withAccessControl ? this.defaultFilter(tenantId, allowDeleted) : this.defaultFilterWithNoACL(tenantId, allowDeleted)).and(AbstractJdbcExecutionRepository.field("key").eq((Object)id));
            return this.jdbcRepository.fetchOne(from);
        });
    }

    protected abstract Condition findCondition(String var1, Map<String, String> var2);

    @Override
    protected Condition findQueryCondition(String query) {
        return this.findCondition(query, Map.of());
    }

    protected abstract Condition findCondition(Map<?, ?> var1, QueryFilter.Op var2);

    @Override
    protected Condition findLabelCondition(Map<?, ?> value, QueryFilter.Op operation) {
        return this.findCondition(value, operation);
    }

    @Override
    protected Condition statesFilter(List<State.Type> state) {
        return AbstractJdbcExecutionRepository.field("state_current").in(state.stream().map(Enum::name).toList());
    }

    public ArrayListTotal<Execution> find(Pageable pageable, @Nullable String tenantId, @Nullable List<QueryFilter> filters) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<Record1<Object>> select = this.findSelect(context, tenantId, filters);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public Flux<Execution> find(@Nullable String query, @Nullable String tenantId, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId, @Nullable ExecutionRepositoryInterface.ChildFilter childFilter, boolean deleted) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep<Record1<Object>> select = this.findSelect(context, query, tenantId, scope, namespace, flowId, startDate, endDate, state, labels, triggerExecutionId, childFilter, deleted);
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(this.jdbcRepository::map).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    private SelectConditionStep<Record1<Object>> findSelect(DSLContext context, @Nullable String tenantId, @Nullable List<QueryFilter> filters) {
        SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId, false)).and(NORMAL_KIND_CONDITION);
        select = select.and(this.filter(filters, "start_date", QueryFilter.Resource.EXECUTION));
        return select;
    }

    private SelectConditionStep<Record1<Object>> findSelect(DSLContext context, @Nullable String query, @Nullable String tenantId, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId, @Nullable ExecutionRepositoryInterface.ChildFilter childFilter, boolean deleted) {
        SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId, deleted));
        select = this.filteringQuery(select, scope, namespace, flowId, null, query, labels, triggerExecutionId, childFilter);
        if (startDate != null) {
            select = select.and(START_DATE_FIELD.greaterOrEqual((Object)startDate.toOffsetDateTime()));
        }
        if (endDate != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("end_date").lessOrEqual((Object)endDate.toOffsetDateTime()));
        }
        if (state != null) {
            select = select.and(this.statesFilter(state));
        }
        return select;
    }

    public Flux<Execution> findAllAsync(@Nullable String tenantId) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(record -> this.jdbcRepository.map(record)).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public ArrayListTotal<Execution> findByFlowId(String tenantId, String namespace, String id, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)id));
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    public ArrayListTotal<TaskRun> findTaskRun(Pageable pageable, @Nullable String tenantId, List<QueryFilter> filters) {
        throw new UnsupportedOperationException();
    }

    public List<DailyExecutionStatistics> dailyStatisticsForAllTenants(@Nullable String query, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, boolean isTaskRun) {
        if (isTaskRun) {
            throw new UnsupportedOperationException();
        }
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        Results results = this.dailyStatisticsQueryForAllTenants(List.of(STATE_CURRENT_FIELD), query, namespace, flowId, null, finalStartDate, finalEndDate, groupBy, null);
        return this.dailyStatisticsQueryMapRecord((Result<Record>)((ResultOrRows)results.resultsOrRows().getFirst()).result(), finalStartDate, finalEndDate, groupBy);
    }

    public List<DailyExecutionStatistics> dailyStatistics(@Nullable String query, @Nullable String tenantId, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, @Nullable List<State.Type> states, boolean isTaskRun) {
        if (isTaskRun) {
            throw new UnsupportedOperationException();
        }
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        Results results = this.dailyStatisticsQuery(List.of(STATE_CURRENT_FIELD), query, tenantId, scope, namespace, flowId, null, finalStartDate, finalEndDate, groupBy, states);
        return this.dailyStatisticsQueryMapRecord((Result<Record>)((ResultOrRows)results.resultsOrRows().getFirst()).result(), finalStartDate, finalEndDate, groupBy);
    }

    private List<DailyExecutionStatistics> dailyStatisticsQueryMapRecord(Result<Record> records, ZonedDateTime startDate, ZonedDateTime endDate, @Nullable DateUtils.GroupType groupType) {
        DateUtils.GroupType groupByType = groupType != null ? groupType : DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        return AbstractJdbcExecutionRepository.fillDate(records.stream().map(record -> ExecutionStatistics.builder().date(this.jdbcRepository.getDate(record, groupByType.val())).durationMax((Long)record.get("duration_max", Long.class)).durationMin((Long)record.get("duration_min", Long.class)).durationSum((Long)record.get("duration_sum", Long.class)).stateCurrent((String)record.get("state_current", String.class)).count((Long)record.get("count", Long.class)).build()).collect(Collectors.groupingBy(ExecutionStatistics::getDate)).entrySet().stream().map(dateResultEntry -> this.dailyExecutionStatisticsMap((Instant)dateResultEntry.getKey(), (List)dateResultEntry.getValue(), groupByType.val())).sorted(Comparator.comparing(DailyExecutionStatistics::getStartDate)).toList(), startDate, endDate);
    }

    private Results dailyStatisticsQueryForAllTenants(List<Field<?>> fields, @Nullable String query, @Nullable String namespace, @Nullable String flowId, List<ExecutionRepositoryInterface.FlowFilter> flows, ZonedDateTime startDate, ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, @Nullable List<State.Type> state) {
        return this.dailyStatisticsQuery(this.defaultFilter(), fields, query, null, namespace, flowId, flows, startDate, endDate, groupBy, state);
    }

    private Results dailyStatisticsQuery(List<Field<?>> fields, @Nullable String query, @Nullable String tenantId, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, List<ExecutionRepositoryInterface.FlowFilter> flows, ZonedDateTime startDate, ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, @Nullable List<State.Type> state) {
        return this.dailyStatisticsQuery(this.defaultFilter(tenantId), fields, query, scope, namespace, flowId, flows, startDate, endDate, groupBy, state);
    }

    private Results dailyStatisticsQuery(Condition defaultFilter, List<Field<?>> fields, @Nullable String query, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, List<ExecutionRepositoryInterface.FlowFilter> flows, ZonedDateTime startDate, ZonedDateTime endDate, @Nullable DateUtils.GroupType groupBy, @Nullable List<State.Type> state) {
        ArrayList dateFields = new ArrayList(this.groupByFields(Duration.between(startDate, endDate), "start_date", groupBy));
        ArrayList selectFields = new ArrayList(fields);
        selectFields.addAll(List.of(DSL.count().as("count"), DSL.min(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_min"), DSL.max(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_max"), DSL.sum(AbstractJdbcExecutionRepository.field("state_duration", Long.class)).as("duration_sum")));
        selectFields.addAll(this.groupByFields(Duration.between(startDate, endDate), "start_date", groupBy, true));
        return (Results)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select((Collection)selectFields).from(this.jdbcRepository.getTable()).where(defaultFilter).and(NORMAL_KIND_CONDITION).and(START_DATE_FIELD.greaterOrEqual((Object)startDate.toOffsetDateTime())).and(START_DATE_FIELD.lessOrEqual((Object)endDate.toOffsetDateTime()));
            select = this.filteringQuery(select, scope, namespace, flowId, flows, query, null, null, null);
            if (state != null) {
                select = select.and(this.statesFilter(state));
            }
            ArrayList groupFields = new ArrayList(fields);
            groupFields.addAll(dateFields);
            SelectHavingStep finalQuery = select.groupBy(groupFields);
            return finalQuery.fetchMany();
        });
    }

    private <T extends Record> SelectConditionStep<T> filteringQuery(SelectConditionStep<T> select, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, @Nullable List<ExecutionRepositoryInterface.FlowFilter> flows, @Nullable String query, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId, @Nullable ExecutionRepositoryInterface.ChildFilter childFilter) {
        if (scope != null && !scope.containsAll(Arrays.stream(FlowScope.values()).toList())) {
            if (scope.contains(FlowScope.USER)) {
                select = select.and(AbstractJdbcExecutionRepository.field("namespace").ne((Object)this.namespaceUtils.getSystemFlowNamespace()));
            } else if (scope.contains(FlowScope.SYSTEM)) {
                select = select.and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)this.namespaceUtils.getSystemFlowNamespace()));
            }
        }
        if (namespace != null) {
            select = flowId != null ? select.and(AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace)) : select.and(DSL.or((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)namespace), (Condition)AbstractJdbcExecutionRepository.field("namespace").likeIgnoreCase(namespace + ".%")));
        }
        if (flowId != null) {
            select = select.and(DSL.or((Condition[])new Condition[]{AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flowId)}));
        }
        if (query != null || labels != null) {
            select = select.and(this.findCondition(query, labels));
        }
        if (triggerExecutionId != null) {
            select = select.and(AbstractJdbcExecutionRepository.field("trigger_execution_id").eq((Object)triggerExecutionId));
        }
        if (childFilter != null) {
            if (childFilter.equals((Object)ExecutionRepositoryInterface.ChildFilter.CHILD)) {
                select = select.and(AbstractJdbcExecutionRepository.field("trigger_execution_id").isNotNull());
            } else if (childFilter.equals((Object)ExecutionRepositoryInterface.ChildFilter.MAIN)) {
                select = select.and(AbstractJdbcExecutionRepository.field("trigger_execution_id").isNull());
            }
        }
        if (flows != null) {
            select = select.and(DSL.or(flows.stream().map(e -> AbstractJdbcExecutionRepository.field("namespace").eq((Object)e.getNamespace()).and(AbstractJdbcExecutionRepository.field("flow_id").eq((Object)e.getId()))).toList()));
        }
        return select;
    }

    private static List<DailyExecutionStatistics> fillDate(List<DailyExecutionStatistics> results, ZonedDateTime startDate, ZonedDateTime endDate) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        if (groupByType.equals((Object)DateUtils.GroupType.MONTH)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.MONTHS, "YYYY-MM", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.WEEK)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.WEEKS, "YYYY-ww", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.DAY)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.DAYS, "YYYY-MM-DD", groupByType.val());
        }
        if (groupByType.equals((Object)DateUtils.GroupType.HOUR)) {
            return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.HOURS, "YYYY-MM-DD HH", groupByType.val());
        }
        return AbstractJdbcExecutionRepository.fillDate(results, startDate, endDate, ChronoUnit.MINUTES, "YYYY-MM-DD HH:mm", groupByType.val());
    }

    private static List<DailyExecutionStatistics> fillDate(List<DailyExecutionStatistics> results, ZonedDateTime startDate, ZonedDateTime endDate, ChronoUnit unit, String format, String groupByType) {
        ArrayList<DailyExecutionStatistics> filledResult = new ArrayList<DailyExecutionStatistics>();
        ZonedDateTime currentDate = startDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        String formattedEndDate = endDate.plus(1L, unit).format(formatter);
        while (!currentDate.format(formatter).equals(formattedEndDate)) {
            String finalCurrentDate = currentDate.format(formatter);
            DailyExecutionStatistics dailyExecutionStatistics = results.stream().filter(e -> formatter.format(e.getStartDate()).equals(finalCurrentDate)).findFirst().orElse(DailyExecutionStatistics.builder().startDate(currentDate.toInstant()).groupBy(groupByType).duration(DailyExecutionStatistics.Duration.builder().build()).build());
            filledResult.add(dailyExecutionStatistics);
            currentDate = currentDate.plus(1L, unit);
        }
        return filledResult;
    }

    private DailyExecutionStatistics dailyExecutionStatisticsMap(Instant date, List<ExecutionStatistics> result, String groupByType) {
        long durationSum = result.stream().map(ExecutionStatistics::getDurationSum).mapToLong(value -> value).sum();
        long count = result.stream().map(ExecutionStatistics::getCount).mapToLong(value -> value).sum();
        DailyExecutionStatistics build = DailyExecutionStatistics.builder().startDate(date).groupBy(groupByType).duration(DailyExecutionStatistics.Duration.builder().avg(Duration.ofMillis(durationSum / count)).min((Duration)result.stream().map(ExecutionStatistics::getDurationMin).min(Long::compare).map(Duration::ofMillis).orElse(null)).max((Duration)result.stream().map(ExecutionStatistics::getDurationMax).max(Long::compare).map(Duration::ofMillis).orElse(null)).sum(Duration.ofMillis(durationSum)).count(count).build()).build();
        result.forEach(record -> build.getExecutionCounts().compute(State.Type.valueOf((String)record.getStateCurrent()), (type, current) -> record.getCount()));
        return build;
    }

    public List<ExecutionCount> executionCounts(@Nullable String tenantId, List<Flow> flows, @Nullable List<State.Type> states, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<String> namespaces) {
        ZonedDateTime finalStartDate = startDate == null ? ZonedDateTime.now().minusDays(30L) : startDate;
        ZonedDateTime finalEndDate = endDate == null ? ZonedDateTime.now() : endDate;
        List result = (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext dslContext = DSL.using((Configuration)configuration);
            SelectConditionStep select = dslContext.select(List.of(AbstractJdbcExecutionRepository.field("namespace"), AbstractJdbcExecutionRepository.field("flow_id"), DSL.count().as("count"))).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(NORMAL_KIND_CONDITION);
            select = select.and(START_DATE_FIELD.greaterOrEqual((Object)finalStartDate.toOffsetDateTime()));
            select = select.and(START_DATE_FIELD.lessOrEqual((Object)finalEndDate.toOffsetDateTime()));
            if (!ListUtils.isEmpty((List)states)) {
                select = select.and(this.statesFilter(states));
            }
            ArrayList<Condition> orConditions = new ArrayList<Condition>();
            orConditions.addAll(ListUtils.emptyOnNull((List)flows).stream().map(flow -> DSL.and((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)flow.getNamespace()), (Condition)AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flow.getFlowId()))).toList());
            orConditions.addAll(ListUtils.emptyOnNull((List)namespaces).stream().map(np -> AbstractJdbcExecutionRepository.field("namespace").eq(np)).toList());
            select = select.and(DSL.or(orConditions));
            return ((ResultOrRows)select.groupBy(List.of(AbstractJdbcExecutionRepository.field("namespace"), AbstractJdbcExecutionRepository.field("flow_id"))).fetchMany().resultsOrRows().getFirst()).result().stream().map(record -> new ExecutionCount((String)record.getValue("namespace", String.class), (String)record.getValue("flow_id", String.class), (Long)record.getValue("count", Long.class))).toList();
        });
        ArrayList<ExecutionCount> counts = new ArrayList<ExecutionCount>();
        if (!ListUtils.isEmpty(flows)) {
            counts.addAll(flows.stream().map(flow -> result.stream().filter(executionCount -> executionCount.getNamespace().equals(flow.getNamespace()) && executionCount.getFlowId().equals(flow.getFlowId())).findFirst().orElse(new ExecutionCount(flow.getNamespace(), flow.getFlowId(), Long.valueOf(0L)))).toList());
        }
        if (!ListUtils.isEmpty(namespaces)) {
            Map<String, Long> groupedByNamespace = result.stream().collect(Collectors.groupingBy(ExecutionCount::getNamespace, Collectors.summingLong(ExecutionCount::getCount)));
            counts.addAll(groupedByNamespace.entrySet().stream().map(entry -> new ExecutionCount((String)entry.getKey(), null, (Long)entry.getValue())).toList());
        }
        return counts;
    }

    public List<Execution> lastExecutions(String tenantId, @Nullable List<ExecutionRepositoryInterface.FlowFilter> flows) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep subquery = context.select(AbstractJdbcExecutionRepository.field("value"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{AbstractJdbcExecutionRepository.field("namespace"), AbstractJdbcExecutionRepository.field("flow_id")}).orderBy(new OrderField[]{AbstractJdbcExecutionRepository.field("end_date").desc()})).as("row_num")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId)).and(NORMAL_KIND_CONDITION).and(AbstractJdbcExecutionRepository.field("end_date").isNotNull()).and(DSL.or((Condition[])new Condition[]{ListUtils.emptyOnNull((List)flows).isEmpty() ? DSL.trueCondition() : DSL.or(flows.stream().map(flow -> DSL.and((Condition)AbstractJdbcExecutionRepository.field("namespace").eq((Object)flow.getNamespace()), (Condition)AbstractJdbcExecutionRepository.field("flow_id").eq((Object)flow.getId()))).toList())}));
            Table cte = subquery.asTable("cte");
            SelectConditionStep mainQuery = context.select((SelectField)cte.field("value")).from((TableLike)cte).where(AbstractJdbcExecutionRepository.field("row_num").eq((Object)1));
            return mainQuery.fetch().map(this.jdbcRepository::map);
        });
    }

    public Execution save(Execution execution) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(execution);
        this.jdbcRepository.persist(execution, fields);
        return execution;
    }

    @Override
    public Execution save(DSLContext dslContext, Execution execution) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(execution);
        this.jdbcRepository.persist(execution, dslContext, fields);
        return execution;
    }

    public int saveBatch(List<Execution> items) {
        if (ListUtils.isEmpty(items)) {
            return 0;
        }
        return this.jdbcRepository.persistBatch(items);
    }

    public Execution update(Execution execution) {
        return (Execution)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSL.using((Configuration)configuration).update(this.jdbcRepository.getTable()).set(this.jdbcRepository.persistFields(execution)).where(AbstractJdbcExecutionRepository.field("key").eq((Object)execution.getId())).execute();
            return execution;
        });
    }

    public Execution delete(Execution execution) {
        Optional revision = this.findById(execution.getTenantId(), execution.getId());
        if (revision.isEmpty()) {
            throw new IllegalStateException("Execution " + execution.getId() + " doesn't exists");
        }
        Execution deleted = execution.toDeleted();
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(deleted);
        this.jdbcRepository.persist(deleted, fields);
        this.executionQueue().emit((Object)deleted);
        this.eventPublisher.publishEvent((Object)CrudEvent.delete((Object)deleted));
        return deleted;
    }

    public Integer purge(Execution execution) {
        int delete = this.jdbcRepository.delete(execution);
        this.eventPublisher.publishEvent((Object)CrudEvent.delete((Object)execution));
        return delete;
    }

    public Integer purge(List<Execution> executions) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            executions.forEach(execution -> this.eventPublisher.publishEvent((Object)CrudEvent.delete((Object)execution)));
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcExecutionRepository.field("key", String.class).in(executions.stream().map(Execution::getId).toList())).execute();
        });
    }

    public Executor lock(String executionId, Function<Pair<Execution, ExecutorState>, Pair<Executor, ExecutorState>> function) {
        return (Executor)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectForUpdateOfStep from = context.select(AbstractJdbcExecutionRepository.field("value")).from(this.jdbcRepository.getTable()).where(AbstractJdbcExecutionRepository.field("key").eq((Object)executionId)).and(this.defaultFilter()).forUpdate();
            Optional<Execution> execution = this.jdbcRepository.fetchOne(from);
            if (execution.isEmpty()) {
                return null;
            }
            ExecutorState executorState = this.executorStateStorage.get(context, execution.get());
            Pair pair = (Pair)function.apply(Pair.of((Object)execution.get(), (Object)executorState));
            if (pair != null) {
                this.jdbcRepository.persist(((Executor)pair.getKey()).getExecution(), context, null);
                this.executorStateStorage.save(context, (ExecutorState)pair.getRight());
                return (Executor)pair.getKey();
            }
            return null;
        });
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("id", "id", "state.startDate", "start_date", "state.endDate", "end_date", "state.duration", "state_duration", "namespace", "namespace", "flowId", "flow_id", "state.current", "state_current");
        return mapper::get;
    }

    public ArrayListTotal<Map<String, Object>> fetchData(String tenantId, DataFilter<IExecutions.Fields, ? extends ColumnDescriptor<IExecutions.Fields>> descriptors, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<String, ColumnDescriptor> columnsWithoutDate = descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getField() == null || !this.dateFields().contains(((ColumnDescriptor)entry.getValue()).getField())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean hasAgg = descriptors.getColumns().entrySet().stream().anyMatch(col -> ((ColumnDescriptor)col.getValue()).getAgg() != null);
            List<Field<Date>> dateFields = this.generateDateFields(descriptors, this.fieldsMapping, startDate, endDate, this.dateFields(), hasAgg ? null : DateUtils.GroupType.MINUTE);
            SelectConditionStep<Record> selectConditionStep = this.select(context, this.filterService, columnsWithoutDate, dateFields, this.getFieldsMapping(), this.jdbcRepository.getTable(), tenantId);
            selectConditionStep = this.where(selectConditionStep, this.filterService, descriptors.getWhere(), this.fieldsMapping);
            List<ColumnDescriptor> columnsWithoutDateWithOutAggs = columnsWithoutDate.values().stream().filter(column -> column.getAgg() == null).toList();
            SelectHavingStep<Record> selectHavingStep = this.groupBy(selectConditionStep, columnsWithoutDateWithOutAggs, dateFields, this.fieldsMapping);
            SelectSeekStepN<Record> selectSeekStep = this.orderBy(selectHavingStep, descriptors);
            return this.fetchSeekStep(selectSeekStep, pageable);
        });
    }

    public Double fetchValue(String tenantId, DataFilterKPI<IExecutions.Fields, ? extends ColumnDescriptor<IExecutions.Fields>> dataFilter, ZonedDateTime startDate, ZonedDateTime endDate, boolean numeratorFilter) {
        return (Double)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep selectStep;
            SelectConditionStep<Record> selectConditionStep;
            Record result;
            DSLContext context = DSL.using((Configuration)configuration);
            ColumnDescriptor columnDescriptor = dataFilter.getColumns();
            String columnKey = this.getFieldsMapping().get(columnDescriptor.getField());
            Field<?> field = this.columnToField(columnDescriptor, this.getFieldsMapping());
            if (columnDescriptor.getAgg() != null) {
                field = this.filterService.buildAggregation(field, columnDescriptor.getAgg());
            }
            ArrayList filters = new ArrayList(ListUtils.emptyOnNull((List)dataFilter.getWhere()));
            if (numeratorFilter) {
                filters.addAll(dataFilter.getNumerator());
            }
            if ((result = (selectConditionStep = this.where((SelectConditionStep<Record>)(selectStep = context.select(field).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId))), this.filterService, filters, this.getFieldsMapping())).fetchOne()) != null) {
                return (Double)result.getValue(field, Double.class);
            }
            return null;
        });
    }

    @Override
    protected <F extends Enum<F>> Field<?> columnToField(ColumnDescriptor<?> column, Map<F, String> fieldsMapping) {
        if (column.getField() == null) {
            return null;
        }
        Field<Object> field = AbstractJdbcExecutionRepository.field(fieldsMapping.get(column.getField()));
        if (field.getName().equals(STATE_CURRENT_FIELD.getName())) {
            return STATE_CURRENT_FIELD;
        }
        if (field.getName().equals(NAMESPACE_FIELD.getName())) {
            return NAMESPACE_FIELD;
        }
        if (field.getName().equals(START_DATE_FIELD.getName())) {
            return START_DATE_FIELD;
        }
        if (field.getName().equals(fieldsMapping.get(IExecutions.Fields.DURATION))) {
            return DSL.field((String)"{0} / 1000", Long.class, (QueryPart[])new QueryPart[]{field});
        }
        return field;
    }

    @Override
    protected <F extends Enum<F>> SelectConditionStep<Record> where(SelectConditionStep<Record> selectConditionStep, JdbcFilterService jdbcFilterService, List<AbstractFilter<F>> filters, Map<F, String> fieldsMapping) {
        if (!ListUtils.isEmpty(filters)) {
            selectConditionStep = this.applyStateFilters(filters, selectConditionStep);
            List<Contains> labelFilters = filters.stream().filter(descriptor -> descriptor.getField().equals(IExecutions.Fields.LABELS) && descriptor instanceof Contains).map(descriptor -> (Contains)descriptor).toList();
            if (!labelFilters.isEmpty()) {
                HashMap<String, String> mergedMap = new HashMap<String, String>();
                labelFilters.forEach(labelFilter -> {
                    Map map;
                    Object patt0$temp = labelFilter.getValue();
                    if (patt0$temp instanceof String) {
                        String stringLabel = (String)patt0$temp;
                        map = Label.from((String)stringLabel);
                    } else {
                        map = (Map)labelFilter.getValue();
                    }
                    Map currentMap = map;
                    mergedMap.putAll(currentMap);
                });
                selectConditionStep = selectConditionStep.and(this.findCondition(null, mergedMap));
            }
            List<AbstractFilter> remainingFilters = filters.stream().filter(descriptor -> !descriptor.getField().equals(IExecutions.Fields.STATE)).filter(descriptor -> !descriptor.getField().equals(IExecutions.Fields.LABELS) || !(descriptor instanceof Contains)).toList();
            return (SelectConditionStep)this.filterService.addFilters(selectConditionStep, fieldsMapping, remainingFilters);
        }
        return selectConditionStep;
    }

    private <F extends Enum<F>> SelectConditionStep<Record> applyStateFilters(List<AbstractFilter<F>> filters, SelectConditionStep<Record> selectConditionStep) {
        List stateNotFilters;
        List stateFilters = filters.stream().flatMap(descriptor -> {
            if (descriptor.getField().equals(IExecutions.Fields.STATE)) {
                if (descriptor instanceof In) {
                    In inFilter = (In)descriptor;
                    return inFilter.getValues().stream();
                }
                if (descriptor instanceof EqualTo) {
                    EqualTo equalToFilter = (EqualTo)descriptor;
                    return Stream.of(equalToFilter.getValue());
                }
            }
            return Stream.empty();
        }).toList();
        if (!stateFilters.isEmpty()) {
            selectConditionStep = selectConditionStep.and(this.statesFilter(stateFilters.stream().map(State.Type::valueOf).toList()));
        }
        if (!(stateNotFilters = filters.stream().flatMap(descriptor -> {
            if (descriptor.getField().equals(IExecutions.Fields.STATE)) {
                if (descriptor instanceof NotIn) {
                    NotIn notInFilter = (NotIn)descriptor;
                    return notInFilter.getValues().stream();
                }
                if (descriptor instanceof NotEqualTo) {
                    NotEqualTo notEqualToFilter = (NotEqualTo)descriptor;
                    return Stream.of(notEqualToFilter.getValue());
                }
            }
            return Stream.empty();
        }).toList()).isEmpty()) {
            selectConditionStep = selectConditionStep.and(DSL.not((Condition)this.statesFilter(stateNotFilters.stream().map(State.Type::valueOf).toList())));
        }
        return selectConditionStep;
    }

    @Override
    protected abstract Field<Date> formatDateField(String var1, DateUtils.GroupType var2);

    @Generated
    public Map<IExecutions.Fields, String> getFieldsMapping() {
        return this.fieldsMapping;
    }
}

