/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.MetricEntry;
import io.kestra.core.models.executions.metrics.MetricAggregation;
import io.kestra.core.models.executions.metrics.MetricAggregations;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.MetricRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.jdbc.repository.AbstractJdbcRepository;
import io.kestra.jdbc.services.JdbcFilterService;
import io.kestra.plugin.core.dashboard.data.IMetrics;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.Pageable;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.SelectSeekStepN;
import org.jooq.impl.DSL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public abstract class AbstractJdbcMetricRepository
extends AbstractJdbcRepository
implements MetricRepositoryInterface {
    private static final Condition NORMAL_KIND_CONDITION = AbstractJdbcMetricRepository.field("execution_kind").isNull();
    protected io.kestra.jdbc.AbstractJdbcRepository<MetricEntry> jdbcRepository;
    private final JdbcFilterService filterService;
    private final Map<IMetrics.Fields, String> fieldsMapping = Map.of(IMetrics.Fields.NAMESPACE, "namespace", IMetrics.Fields.FLOW_ID, "flow_id", IMetrics.Fields.TASK_ID, "task_id", IMetrics.Fields.EXECUTION_ID, "execution_d", IMetrics.Fields.TASK_RUN_ID, "taskrun_id", IMetrics.Fields.NAME, "metric_name", IMetrics.Fields.VALUE, "metric_value", IMetrics.Fields.DATE, "timestamp");

    public AbstractJdbcMetricRepository(io.kestra.jdbc.AbstractJdbcRepository<MetricEntry> jdbcRepository, JdbcFilterService filterService) {
        this.jdbcRepository = jdbcRepository;
        this.filterService = filterService;
    }

    public Set<IMetrics.Fields> dateFields() {
        return Set.of(IMetrics.Fields.DATE);
    }

    public IMetrics.Fields dateFilterField() {
        return IMetrics.Fields.DATE;
    }

    public ArrayListTotal<MetricEntry> findByExecutionId(String tenantId, String executionId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId), pageable);
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskId(String tenantId, String executionId, String taskId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId)), pageable);
    }

    public ArrayListTotal<MetricEntry> findByExecutionIdAndTaskRunId(String tenantId, String executionId, String taskRunId, Pageable pageable) {
        return this.query(tenantId, AbstractJdbcMetricRepository.field("execution_id").eq((Object)executionId).and(AbstractJdbcMetricRepository.field("taskrun_id").eq((Object)taskRunId)), pageable);
    }

    public Flux<MetricEntry> findAllAsync(@Nullable String tenantId) {
        return Flux.create(emitter -> this.jdbcRepository.getDslContextWrapper().transaction(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcMetricRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            try (Stream stream = select.fetchSize(100).stream();){
                stream.map(record -> this.jdbcRepository.map(record)).forEach(arg_0 -> ((FluxSink)emitter).next(arg_0));
            }
            finally {
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public List<String> flowMetrics(String tenantId, String namespace, String flowId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(NORMAL_KIND_CONDITION), "metric_name");
    }

    public List<String> taskMetrics(String tenantId, String namespace, String flowId, String taskId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId)).and(NORMAL_KIND_CONDITION), "metric_name");
    }

    public List<String> tasksWithMetrics(String tenantId, String namespace, String flowId) {
        return this.queryDistinct(tenantId, AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(NORMAL_KIND_CONDITION), "task_id");
    }

    public MetricAggregations aggregateByFlowId(String tenantId, String namespace, String flowId, @io.micrometer.common.lang.Nullable String taskId, String metric, ZonedDateTime startDate, ZonedDateTime endDate, String aggregation) {
        Condition conditions = AbstractJdbcMetricRepository.field("flow_id").eq((Object)flowId).and(AbstractJdbcMetricRepository.field("namespace").eq((Object)namespace)).and(AbstractJdbcMetricRepository.field("metric_name").eq((Object)metric)).and(NORMAL_KIND_CONDITION);
        if (taskId != null) {
            conditions = conditions.and(AbstractJdbcMetricRepository.field("task_id").eq((Object)taskId));
        }
        return MetricAggregations.builder().aggregations(this.aggregate(tenantId, conditions, startDate, endDate, aggregation)).groupBy(DateUtils.groupByType((Duration)Duration.between(startDate, endDate)).val()).build();
    }

    public MetricEntry save(MetricEntry metric) {
        Map<Field<Object>, Object> fields = this.jdbcRepository.persistFields(metric);
        this.jdbcRepository.persist(metric, fields);
        return metric;
    }

    public int saveBatch(List<MetricEntry> items) {
        if (ListUtils.isEmpty(items)) {
            return 0;
        }
        return this.jdbcRepository.persistBatch(items);
    }

    public Integer purge(Execution execution) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcMetricRepository.field("deleted", Boolean.class).eq((Object)false)).and(AbstractJdbcMetricRepository.field("execution_id", String.class).eq((Object)execution.getId())).execute();
        });
    }

    public Integer purge(List<Execution> executions) {
        return (Integer)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.delete(this.jdbcRepository.getTable()).where(AbstractJdbcMetricRepository.field("deleted", Boolean.class).eq((Object)false)).and(AbstractJdbcMetricRepository.field("execution_id", String.class).in(executions.stream().map(Execution::getId).toList())).execute();
        });
    }

    private List<String> queryDistinct(String tenantId, Condition condition, String field) {
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.selectDistinct(AbstractJdbcMetricRepository.field(field)).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            return select.fetch().map(record -> (String)record.get(field, String.class));
        });
    }

    private ArrayListTotal<MetricEntry> query(String tenantId, Condition condition, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            SelectConditionStep select = context.select(AbstractJdbcMetricRepository.field("value")).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            return this.jdbcRepository.fetchPage(context, select, pageable);
        });
    }

    private List<MetricAggregation> aggregate(String tenantId, Condition condition, ZonedDateTime startDate, ZonedDateTime endDate, String aggregation) {
        ArrayList dateFields = new ArrayList(this.groupByFields(Duration.between(startDate, endDate), true));
        return (List)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep select = DSL.using((Configuration)configuration).select((Collection)dateFields).select(new SelectFieldOrAsterisk[]{AbstractJdbcMetricRepository.field("metric_name"), this.aggregate(aggregation)}).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId));
            select = select.and(condition);
            if (startDate != null) {
                select = select.and(AbstractJdbcMetricRepository.field("timestamp").greaterOrEqual((Object)startDate.toOffsetDateTime()));
            }
            if (endDate != null) {
                select = select.and(AbstractJdbcMetricRepository.field("timestamp").lessOrEqual((Object)endDate.toOffsetDateTime()));
            }
            dateFields.add(AbstractJdbcMetricRepository.field("metric_name"));
            ArrayList groupByFields = new ArrayList(this.groupByFields(Duration.between(startDate, endDate)));
            groupByFields.add(AbstractJdbcMetricRepository.field("metric_name"));
            SelectHavingStep selectGroup = select.groupBy(groupByFields);
            List<MetricAggregation> result = this.jdbcRepository.fetchMetricStat((Select<Record>)selectGroup, DateUtils.groupByType((Duration)Duration.between(startDate, endDate)).val());
            List<MetricAggregation> fillResult = this.fillDate(result, startDate, endDate);
            return fillResult;
        });
    }

    private Field<?> aggregate(String aggregation) {
        return switch (aggregation) {
            case "avg" -> DSL.avg(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "sum" -> DSL.sum(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "min" -> DSL.min(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            case "max" -> DSL.max(AbstractJdbcMetricRepository.field("metric_value", Double.class)).as("metric_value");
            default -> throw new IllegalArgumentException("Invalid aggregation: " + aggregation);
        };
    }

    private List<MetricAggregation> fillDate(List<MetricAggregation> result, ZonedDateTime startDate, ZonedDateTime endDate) {
        DateUtils.GroupType groupByType = DateUtils.groupByType((Duration)Duration.between(startDate, endDate));
        if (groupByType.equals((Object)DateUtils.GroupType.MONTH)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.MONTHS, "YYYY-MM");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.WEEK)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.WEEKS, "YYYY-ww");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.DAY)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.DAYS, "YYYY-MM-DD");
        }
        if (groupByType.equals((Object)DateUtils.GroupType.HOUR)) {
            return this.fillDate(result, startDate, endDate, ChronoUnit.HOURS, "YYYY-MM-DD HH");
        }
        return this.fillDate(result, startDate, endDate, ChronoUnit.MINUTES, "YYYY-MM-DD HH:mm");
    }

    private List<MetricAggregation> fillDate(List<MetricAggregation> result, ZonedDateTime startDate, ZonedDateTime endDate, ChronoUnit unit, String format) {
        ArrayList<MetricAggregation> filledResult = new ArrayList<MetricAggregation>();
        ZonedDateTime currentDate = startDate;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.systemDefault());
        while (currentDate.isBefore(endDate)) {
            String finalCurrentDate = currentDate.format(formatter);
            MetricAggregation metricStat = result.stream().filter(metric -> formatter.format(metric.date).equals(finalCurrentDate)).findFirst().orElse(MetricAggregation.builder().date(currentDate.toInstant()).value(Double.valueOf(0.0)).build());
            filledResult.add(metricStat);
            currentDate = currentDate.plus(1L, unit);
        }
        return filledResult;
    }

    public Function<String, String> sortMapping() throws IllegalArgumentException {
        Map<String, String> mapper = Map.of("namespace", "namespace", "flowId", "flow_id", "taskId", "task_id", "executionId", "execution_id", "taskrunId", "taskrun_id", "name", "metric_name", "timestamp", "timestamp", "value", "metric_value");
        return mapper::get;
    }

    public Double fetchValue(String tenantId, DataFilterKPI<IMetrics.Fields, ? extends ColumnDescriptor<IMetrics.Fields>> dataFilter, ZonedDateTime startDate, ZonedDateTime endDate, boolean numeratorFilter) {
        return (Double)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            SelectConditionStep selectStep;
            SelectConditionStep<Record> selectConditionStep;
            Record result;
            DSLContext context = DSL.using((Configuration)configuration);
            ColumnDescriptor columnDescriptor = dataFilter.getColumns();
            String columnKey = this.getFieldsMapping().get(columnDescriptor.getField());
            Field<?> field = this.columnToField(columnDescriptor, this.getFieldsMapping());
            if (columnDescriptor.getAgg() != null) {
                field = this.filterService.buildAggregation(field, columnDescriptor.getAgg());
            }
            ArrayList filters = new ArrayList(ListUtils.emptyOnNull((List)dataFilter.getWhere()));
            if (numeratorFilter) {
                filters.addAll(dataFilter.getNumerator());
            }
            if ((result = (selectConditionStep = this.where((SelectConditionStep<Record>)(selectStep = context.select(field).from(this.jdbcRepository.getTable()).where(this.defaultFilter(tenantId))), this.filterService, filters, this.getFieldsMapping())).fetchOne()) != null) {
                return (Double)result.getValue(field, Double.class);
            }
            return null;
        });
    }

    public ArrayListTotal<Map<String, Object>> fetchData(String tenantId, DataFilter<IMetrics.Fields, ? extends ColumnDescriptor<IMetrics.Fields>> descriptors, ZonedDateTime startDate, ZonedDateTime endDate, Pageable pageable) {
        return (ArrayListTotal)this.jdbcRepository.getDslContextWrapper().transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            Map<String, ColumnDescriptor> columnsWithoutDate = descriptors.getColumns().entrySet().stream().filter(entry -> ((ColumnDescriptor)entry.getValue()).getField() == null || !this.dateFields().contains(((ColumnDescriptor)entry.getValue()).getField())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            boolean hasAgg = descriptors.getColumns().entrySet().stream().anyMatch(col -> ((ColumnDescriptor)col.getValue()).getAgg() != null);
            List<Field<Date>> dateFields = this.generateDateFields(descriptors, this.fieldsMapping, startDate, endDate, this.dateFields(), hasAgg ? null : DateUtils.GroupType.MINUTE);
            SelectConditionStep<Record> selectConditionStep = this.select(context, this.filterService, columnsWithoutDate, dateFields, this.getFieldsMapping(), this.jdbcRepository.getTable(), tenantId);
            selectConditionStep = this.where(selectConditionStep, this.filterService, descriptors.getWhere(), this.fieldsMapping);
            List<ColumnDescriptor> columnsWithoutDateWithOutAggs = columnsWithoutDate.values().stream().filter(column -> column.getAgg() == null).toList();
            SelectHavingStep<Record> selectHavingStep = this.groupBy(selectConditionStep, columnsWithoutDateWithOutAggs, dateFields, this.fieldsMapping);
            SelectSeekStepN<Record> selectSeekStep = this.orderBy(selectHavingStep, descriptors);
            return this.fetchSeekStep(selectSeekStep, pageable);
        });
    }

    @Override
    protected abstract Field<Date> formatDateField(String var1, DateUtils.GroupType var2);

    @Generated
    public JdbcFilterService getFilterService() {
        return this.filterService;
    }

    @Generated
    public Map<IMetrics.Fields, String> getFieldsMapping() {
        return this.fieldsMapping;
    }
}

