/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.jdbc.repository;

import io.kestra.core.repositories.TenantMigrationInterface;
import io.kestra.jdbc.JooqDSLContextWrapper;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcTenantMigration
implements TenantMigrationInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJdbcTenantMigration.class);
    private static final List<String> KEY_TABLES = List.of("dashboards", "flows", "multipleconditions", "namespaces", "testsuites", "triggers", "templates");
    protected final JooqDSLContextWrapper dslContextWrapper;

    protected AbstractJdbcTenantMigration(JooqDSLContextWrapper dslContextWrapper) {
        this.dslContextWrapper = dslContextWrapper;
    }

    public void migrateTenant(String tenantId, boolean dryRun) {
        this.migrate(dryRun);
    }

    public void migrate(boolean dryRun) {
        List tables = (List)this.dslContextWrapper.transactionResult(configuration -> {
            DSLContext context = DSL.using((Configuration)configuration);
            return context.meta().getTables();
        });
        log.info("\ud83d\udce6 Found {} tables.\n", (Object)tables.size());
        int totalAffected = 0;
        for (Table table : tables) {
            Field tenantField = table.field("tenant_id", String.class);
            if (tenantField == null) continue;
            if (!dryRun) {
                if ("flows".equalsIgnoreCase(table.getName()) || "triggers".equalsIgnoreCase(table.getName())) {
                    log.info("\ud83d\udd38 Delete tutorial flows to prevent duplication");
                    int deleted = (Integer)this.dslContextWrapper.transactionResult(configuration -> {
                        DSLContext context = DSL.using((Configuration)configuration);
                        return this.deleteTutorialFlows(table, context);
                    });
                    log.info("\u2705 {} tutorial flows have been deleted", (Object)deleted);
                }
                int updated = AbstractJdbcTenantMigration.tableWithKey(table.getName()) ? ((Integer)this.dslContextWrapper.transactionResult(configuration -> {
                    DSLContext context = DSL.using((Configuration)configuration);
                    return this.updateTenantIdFieldAndKey(table, context);
                })).intValue() : ((Integer)this.dslContextWrapper.transactionResult(configuration -> {
                    DSLContext context = DSL.using((Configuration)configuration);
                    return this.updateTenantIdField(table, context);
                })).intValue();
                totalAffected += updated;
                log.info("\u2705 Updated {} row(s) in {}", (Object)updated, (Object)table.getName());
                continue;
            }
            Condition condition = tenantField.isNull();
            int count = (Integer)this.dslContextWrapper.transactionResult(configuration -> {
                DSLContext context = DSL.using((Configuration)configuration);
                return (Integer)context.selectCount().from((TableLike)table).where(condition).fetchOne(0, Integer.TYPE);
            });
            if (count > 0) {
                log.info("\ud83d\udd38 {}: {} row(s) to update.", (Object)table.getName(), (Object)count);
                totalAffected += count;
                continue;
            }
            log.info("\u2705 {}: No updates needed.", (Object)table.getName());
        }
        if (dryRun) {
            log.info("\ud83e\uddea Dry-run complete. {} row(s) would be updated.", (Object)totalAffected);
        } else {
            log.info("\u2705 Update complete. {} row(s) updated.", (Object)totalAffected);
        }
    }

    private static boolean tableWithKey(String tableName) {
        return KEY_TABLES.stream().anyMatch(name -> tableName.toLowerCase(Locale.ROOT).contains((CharSequence)name));
    }

    protected abstract int updateTenantIdField(Table<?> var1, DSLContext var2);

    protected abstract int updateTenantIdFieldAndKey(Table<?> var1, DSLContext var2);

    protected int deleteTutorialFlows(Table<?> table, DSLContext context) {
        String query = "DELETE FROM %s WHERE namespace = ?".formatted(table.getName());
        return context.execute(query, new Object[]{"tutorial"});
    }
}

